/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.dragdrop;

import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;

public class DndEvent
extends FacesEvent {
    private int eventType;
    private Object targetDropValue;
    private Object targetDragValue;
    private String targetClientId;
    public static final int DRAG_START = 1;
    public static final int DRAGGING = 1;
    public static final int DRAG_CANCEL = 2;
    public static final int DROPPED = 3;
    public static final int HOVER_START = 4;
    public static final int HOVER_END = 5;
    private static String[] names = new String[]{"none", "dragging", "drag_cancel", "dropped", "hover_start", "hover_end", "pointerDraw"};
    public static final String MASK_ALL = "1,2,3,4,5";
    public static final String MASK_ALL_BUT_DROPS = "1,4,5";

    public DndEvent(UIComponent uiComponent, int eventType, String targetClentId, Object targetDragValue, Object targetDropValue) {
        super(uiComponent);
        this.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        this.eventType = eventType;
        this.targetClientId = targetClentId;
        this.targetDragValue = targetDragValue;
        this.targetDropValue = targetDropValue;
    }

    public boolean isAppropriateListener(FacesListener facesListener) {
        return false;
    }

    public void processListener(FacesListener facesListener) {
    }

    public int getEventType() {
        return this.eventType;
    }

    public Object getTargetDropValue() {
        return this.targetDropValue;
    }

    public Object getTargetDragValue() {
        return this.targetDragValue;
    }

    public String getTargetClientId() {
        return this.targetClientId;
    }

    public static String getEventName(int i) {
        return names[i];
    }

    public static String parseMask(String mask) {
        if (mask == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(mask, ",");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            boolean f = false;
            for (int i = 1; i < names.length; ++i) {
                if ((token = token.trim()).length() <= 0 || !token.equalsIgnoreCase(names[i])) continue;
                sb.append(i);
                f = true;
            }
            if (!f) {
                String message = "Mask value [" + token + "] in mask [" + mask + "] is not valid. Valid values are [";
                for (int ie = 1; ie < names.length; ++ie) {
                    message = message + names[ie];
                    int next = ie + 1;
                    if (next < names.length) {
                        message = message + ", ";
                    }
                    message = message + "]";
                }
                throw new IllegalArgumentException(message);
            }
            if (!st.hasMoreTokens()) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

