/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.ASTPair;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.ClassRepository;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.language.antlr.JavaNodeFactory;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.ImportPolicy;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

final class ImportTransformation
extends TreeWalker
implements Transformation {
    private static final Comparator COMP_LINE = new NodeLineComparator();
    private static final Comparator COMP_ON_DEMAND_SINGLE = new NodeOnDemandSingleComparator();
    private static final Comparator COMP_TEXT = new NodeStringComparator();
    private static final int DEFAULT_PACKAGE = -99;
    private static final JavaNode[] EMPTY_NODE_ARRAY = new JavaNode[0];
    private static final String MARKER = "#";
    private static final String EMPTY_STRING = "".intern();
    private static final String PACKAGE_JAVA_LANG = "java.lang.";
    private static final String STAR = "*";
    static final String DOT = ".";
    private static final String DELIMETER_ENTRY = "|";
    private static final Object[] _args = new Object[4];
    private final ImportNodeComparator COMP_IMPORT = new ImportNodeComparator();
    private AST _class;
    private JavaNode _packageNameNode;
    private List _onDemandImports = new ArrayList();
    private final List _qualIdents;
    private AST _root;
    private List _singleTypeImports = new ArrayList();
    private final List _unqualIdents;
    private String _filename;
    private String _packageName = EMPTY_STRING;
    private boolean _sortImports = true;
    private int _line;
    private JavaNodeFactory _factory = null;

    public ImportTransformation(List qualIdents, List unqualIdents, JavaNodeFactory factory) {
        this._qualIdents = qualIdents;
        this._unqualIdents = unqualIdents;
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(AST tree) throws TransformationException {
        try {
            Convention settings = Convention.getInstance();
            ImportPolicy importPolicy = ImportPolicy.valueOf(settings.get(ConventionKeys.IMPORT_POLICY, ConventionDefaults.IMPORT_POLICY));
            boolean expand = importPolicy == ImportPolicy.EXPAND;
            boolean collapse = importPolicy == ImportPolicy.COLLAPSE;
            this._sortImports = settings.getBoolean(ConventionKeys.IMPORT_SORT, true);
            if (!ClassRepository.getInstance().isEmpty()) {
                if (expand) {
                    this.walk(tree);
                    this.expand();
                } else if (collapse) {
                    this.walk(tree);
                    this.collapse();
                } else if (this._sortImports) {
                    this.walk(tree);
                    this.updateTree(this._onDemandImports, this._singleTypeImports);
                }
            } else if (this._sortImports) {
                this.walk(tree);
                this.updateTree(this._onDemandImports, this._singleTypeImports);
            }
            Object var7_6 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void visit(AST node) {
        String identifier = JavaNodeHelper.getDottedName(node.getFirstChild());
        JavaNode importNode = (JavaNode)node;
        if (this._line == 0) {
            this._line = importNode.getStartLine();
        }
        if (identifier.endsWith(STAR)) {
            String packageName = identifier.substring(0, identifier.length() - 2);
            importNode.setText(packageName);
            boolean contains = false;
            JavaNode dup = null;
            Iterator i = this._onDemandImports.iterator();
            while (i.hasNext() && !contains) {
                dup = (JavaNode)i.next();
                contains = dup.getText().equals(importNode.getText());
            }
            if (contains) {
                ImportTransformation._args[0] = this._root.getText();
                ImportTransformation._args[1] = new Integer(importNode.getStartLine());
                ImportTransformation._args[2] = identifier;
                ImportTransformation._args[3] = new Integer(dup.getStartLine());
                Loggers.TRANSFORM.l7dlog((Priority)Level.INFO, "TRANS_IMP_REMOVE_DUPLICATE", _args, null);
            } else {
                this._onDemandImports.add(importNode);
            }
        } else {
            importNode.setText(identifier);
            if (this._singleTypeImports.contains(importNode)) {
                ImportTransformation._args[0] = this._root.getText();
                ImportTransformation._args[1] = new Integer(importNode.getStartLine());
                ImportTransformation._args[2] = identifier;
                ImportTransformation._args[3] = new Integer(((JavaNode)this._singleTypeImports.get(this._singleTypeImports.indexOf(importNode))).getStartLine());
                Loggers.TRANSFORM.l7dlog((Priority)Level.INFO, "TRANS_IMP_REMOVE_DUPLICATE", _args, null);
            } else {
                this._singleTypeImports.add(importNode);
            }
        }
    }

    protected void walkNode(AST node) {
        switch (node.getType()) {
            case 67: {
                this._root = node;
                this._filename = node.getText();
                AST first = node.getFirstChild();
                if (first == null) break;
                this.walkNode(first);
                break;
            }
            case 21: {
                this._packageName = JavaNodeHelper.getDottedName(node.getFirstChild());
                this._packageNameNode = (JavaNode)node;
                AST next = node.getNextSibling();
                if (next == null) break;
                this.walkNode(next);
                break;
            }
            case 35: 
            case 50: {
                this.visit(node);
                AST next = node.getNextSibling();
                if (next == null) break;
                this.walkNode(next);
                break;
            }
            case 74: {
                this.walkNode(node.getNextSibling());
                break;
            }
            case 51: 
            case 54: {
                this._class = node;
                break;
            }
            case 19: 
            case 20: {
                this._class = node;
                if (this._packageNameNode != null) {
                    this._packageNameNode.setNextSibling(node);
                } else {
                    this._root.setFirstChild(node);
                }
                return;
            }
        }
    }

    private boolean isDefaultPackage(String name, String packageName) {
        boolean result = false;
        if (packageName != null) {
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                result = name.substring(0, pos).equals(packageName);
            }
        } else {
            result = name.indexOf(46) == -1;
        }
        return result;
    }

    private List getExpandable(List onDemandImports) {
        ArrayList<JavaNode> result = new ArrayList<JavaNode>(onDemandImports.size());
        int i = 0;
        int size = onDemandImports.size();
        while (i < size) {
            JavaNode node = (JavaNode)onDemandImports.get(i);
            result.add(node);
            ++i;
        }
        JavaNode defaultPckg = this._factory.create(-99, 1, -99, 2);
        defaultPckg.setText(this._packageName);
        defaultPckg.setType(35);
        result.add(defaultPckg);
        return result;
    }

    static int getIndex(List identifiers, String packageName) {
        int i = 0;
        int size = identifiers.size();
        while (i < size) {
            if (packageName.startsWith((String)identifiers.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isLangPackage(String name) {
        return name.startsWith(PACKAGE_JAVA_LANG) && name.lastIndexOf(46) == 9;
    }

    private List getPackageTypes(String packageName) {
        if (packageName == null) {
            return Collections.EMPTY_LIST;
        }
        Object[] content = ClassRepository.getInstance().getContent();
        if (content.length == 0) {
            return Collections.EMPTY_LIST;
        }
        int startOffset = Arrays.binarySearch(content, packageName + '#');
        ArrayList<String> result = new ArrayList<String>(20);
        if (startOffset > -1) {
            int depth = StringHelper.occurs('.', packageName) + 1;
            int i = startOffset + 1;
            while (i < content.length) {
                if (!((String)content[i]).startsWith(packageName)) break;
                if (StringHelper.occurs('.', (String)content[i]) == depth) {
                    result.add(StringHelper.getClassName((String)content[i]));
                }
                ++i;
            }
        }
        return result;
    }

    private List getPossibleSingleTypeImports(List identifiers, List singleTypeImports) {
        int length = identifiers.size();
        ArrayList result = new ArrayList(length);
        int i = 0;
        while (i < length) {
            result.add(identifiers.get(i));
            ++i;
        }
        int i2 = 0;
        int size = singleTypeImports.size();
        while (i2 < size) {
            int j = 0;
            while (j < length) {
                JavaNode node = (JavaNode)singleTypeImports.get(i2);
                if (node.getText().endsWith('.' + (String)identifiers.get(j))) {
                    result.remove(identifiers.get(j));
                }
                ++j;
            }
            ++i2;
        }
        return result;
    }

    private boolean isUsed(String identifier, List types) {
        int i = 0;
        int size = types.size();
        while (i < size) {
            String type = (String)types.get(i);
            if (type.equals(identifier)) {
                return true;
            }
            ++i;
        }
        int i2 = 0;
        int size2 = this._qualIdents.size();
        while (i2 < size2) {
            String type = StringHelper.getClassName((String)this._qualIdents.get(i2));
            if (type.equals(identifier)) {
                return true;
            }
            ++i2;
        }
        int i3 = 0;
        int size3 = this._unqualIdents.size();
        while (i3 < size3) {
            String type = (String)this._unqualIdents.get(i3);
            if (type.endsWith(identifier)) {
                return true;
            }
            ++i3;
        }
        return false;
    }

    private void addComments(JavaNode source, JavaNode target) {
    }

    private void cleanup() {
        this._onDemandImports.clear();
        this._singleTypeImports.clear();
        this._packageName = EMPTY_STRING;
        this._packageNameNode = null;
        this._class = null;
        this._root = null;
        this._filename = null;
        this._line = 0;
    }

    private void collapse() {
        if (this._singleTypeImports.size() > 0) {
            List singleTypeImports = this._singleTypeImports;
            ArrayList<JavaNode> newOnDemandImports = new ArrayList<JavaNode>(singleTypeImports.size());
            newOnDemandImports.addAll(this._onDemandImports);
            JavaNode defaultPackage = (JavaNode)this._factory.create(35, this._packageName);
            defaultPackage.setStartLine(-99);
            newOnDemandImports.add(defaultPackage);
            int i = 0;
            int size = singleTypeImports.size();
            while (i < size) {
                JavaNode singleType = (JavaNode)singleTypeImports.get(i);
                String packageName = StringHelper.getPackageName(singleType.getText());
                if (!EMPTY_STRING.equals(packageName)) {
                    JavaNode onDemand = (JavaNode)this._factory.create(35, packageName);
                    onDemand.setFirstChild(singleType.getFirstChild());
                    if (singleType.hasCommentsBefore()) {
                        // empty if block
                    }
                    if (singleType.hasCommentsAfter()) {
                        // empty if block
                    }
                    if (!newOnDemandImports.contains(onDemand)) {
                        newOnDemandImports.add(onDemand);
                    } else {
                        this.addComments(onDemand, (JavaNode)newOnDemandImports.get(newOnDemandImports.indexOf(onDemand)));
                    }
                }
                ++i;
            }
            HashMap<String, List> allTypes = new HashMap<String, List>(newOnDemandImports.size());
            ArrayList<JavaNode> retainedOnDemandImports = new ArrayList<JavaNode>();
            JavaNode template = (JavaNode)this._factory.create(35, EMPTY_STRING);
            int j = 0;
            int packages = newOnDemandImports.size();
            while (j < packages) {
                JavaNode path = (JavaNode)newOnDemandImports.get(j);
                List packageTypes = this.getPackageTypes(path.getText());
                allTypes.put(path.getText(), packageTypes);
                ++j;
            }
            HashSet<String> conflicts = new HashSet<String>(5);
            List defaultTypes = this.getPackageTypes(this._packageName);
            Iterator firstPackages = allTypes.entrySet().iterator();
            while (firstPackages.hasNext()) {
                Map.Entry firstPackageData = firstPackages.next();
                String firstPackageName = (String)firstPackageData.getKey();
                List firstPackageTypes = (List)firstPackageData.getValue();
                Iterator secondPackages = allTypes.entrySet().iterator();
                while (secondPackages.hasNext()) {
                    Map.Entry secondPackageData = secondPackages.next();
                    String secondPackageName = (String)secondPackageData.getKey();
                    if (conflicts.contains(firstPackageName) || secondPackageName.equals(firstPackageName)) continue;
                    List secondPackageTypes = (List)secondPackageData.getValue();
                    int i2 = 0;
                    int size2 = firstPackageTypes.size();
                    while (i2 < size2) {
                        String type = (String)firstPackageTypes.get(i2);
                        if (!type.endsWith(MARKER) && secondPackageTypes.contains(type) && this.isUsed(type, defaultTypes)) {
                            conflicts.add(firstPackageName);
                            template.setText(firstPackageName);
                            int index = 0;
                            index = newOnDemandImports.indexOf(template);
                            if (index > -1) {
                                JavaNode importNode = (JavaNode)newOnDemandImports.remove(index);
                                if (this._onDemandImports.contains(template)) {
                                    importNode.setText(template.getText());
                                    importNode.setNextSibling(null);
                                    importNode.setPreviousSibling(null);
                                    retainedOnDemandImports.add(importNode);
                                } else if (Loggers.TRANSFORM.isDebugEnabled()) {
                                    Loggers.TRANSFORM.debug((Object)(this._filename + ":0:0: cannot unqualify " + firstPackageName + " due to conflict between " + firstPackageName + '.' + type + " and " + secondPackageName + '.' + type + " (Check 3)"));
                                }
                            }
                        }
                        ++i2;
                    }
                }
            }
            newOnDemandImports.remove(defaultPackage);
            Collections.sort(newOnDemandImports, COMP_TEXT);
            int i3 = 0;
            int size3 = singleTypeImports.size();
            while (i3 < size3) {
                JavaNode node = (JavaNode)singleTypeImports.get(i3);
                if (Collections.binarySearch(newOnDemandImports, node, COMP_ON_DEMAND_SINGLE) > -1) {
                    JavaNode singleType = (JavaNode)singleTypeImports.remove(i3);
                    --size3;
                    --i3;
                    singleType.setFirstChild(null);
                    singleType.setParent(null);
                    singleType.setPreviousSibling(null);
                    singleType.setNextSibling(null);
                }
                ++i3;
            }
            newOnDemandImports.addAll(retainedOnDemandImports);
            this.updateTree(newOnDemandImports, singleTypeImports);
        } else {
            this.updateTree(this._onDemandImports, Collections.EMPTY_LIST);
        }
    }

    private JavaNode createImportNode(JavaNode node) {
        String identifier = node.getText();
        ArrayList<String> parts = new ArrayList<String>(8);
        int endOffset = -1;
        int startOffset = 0;
        while ((endOffset = identifier.indexOf(46, startOffset)) > -1) {
            parts.add(identifier.substring(startOffset, endOffset));
            parts.add(DOT);
            startOffset = endOffset + 1;
        }
        parts.add(identifier.substring(startOffset));
        ASTPair curAST = new ASTPair();
        AST last = this._factory.create(79, (String)parts.remove(0));
        this._factory.addASTChild(curAST, last);
        int i = 0;
        int size = parts.size();
        while (i < size) {
            String next = (String)parts.remove(0);
            if (next.equals(DOT)) {
                last = this._factory.create(80, next);
                this._factory.makeASTRoot(curAST, last);
            } else {
                last = this._factory.create(79, next);
                this._factory.addASTChild(curAST, last);
            }
            ++i;
        }
        JavaNode identifierNode = (JavaNode)node.getFirstChild();
        JavaNode semi = (JavaNode)identifierNode.getNextSibling();
        JavaNode newIdentifierNode = (JavaNode)curAST.root;
        newIdentifierNode.setNextSibling(semi);
        newIdentifierNode.setParent(node);
        semi.setPreviousSibling(newIdentifierNode);
        node.setFirstChild(newIdentifierNode);
        identifierNode.setParent(null);
        identifierNode.setPreviousSibling(null);
        ++this._line;
        return node;
    }

    private void createImportNodes(JavaNode[] imports) {
        if (imports.length == 0) {
            return;
        }
        ImportPolicy importPolicy = ImportPolicy.valueOf(Convention.getInstance().get(ConventionKeys.IMPORT_POLICY, ConventionDefaults.IMPORT_POLICY));
        boolean report = importPolicy == ImportPolicy.EXPAND;
        String filename = this._root.getText();
        JavaNode node = this._packageNameNode;
        boolean showWarnings = !ClassRepository.getInstance().isEmpty();
        int i = 0;
        while (imports.length > 0 && i < 1) {
            JavaNode imp = this.createImportNode(imports[i]);
            switch (imp.getType()) {
                case 35: 
                case 50: {
                    break;
                }
                default: {
                    throw new RuntimeException("" + imp);
                }
            }
            if (report && imports[i].getText().endsWith(STAR)) {
                ImportTransformation._args[0] = filename;
                ImportTransformation._args[1] = new Integer(imports[i].getStartLine());
                ImportTransformation._args[2] = imports[i].getText();
                if (showWarnings) {
                    Loggers.TRANSFORM.l7dlog((Priority)Level.WARN, "TRANS_IMP_NOT_POSSIBLE", _args, null);
                }
            }
            if (node == null) {
                this._root.setFirstChild(imp);
                imp.setParent((JavaNode)this._root);
                imp.setPreviousSibling(imp.getParent());
                this._packageNameNode = imp.getPreviousSibling();
            } else {
                node.setNextSibling(imp);
                imp.setPreviousSibling(node);
                imp.setParent(this._packageNameNode);
            }
            node = imp;
            ++i;
        }
        int i2 = 1;
        while (i2 < imports.length) {
            JavaNode imp = this.createImportNode(imports[i2]);
            switch (imp.getType()) {
                case 35: 
                case 50: {
                    break;
                }
                default: {
                    throw new RuntimeException("2 " + imp);
                }
            }
            if (report && imports[i2].getText().endsWith(STAR)) {
                ImportTransformation._args[0] = filename;
                ImportTransformation._args[1] = new Integer(imports[i2].getStartLine());
                ImportTransformation._args[2] = imports[i2].getText();
                if (showWarnings) {
                    Loggers.TRANSFORM.l7dlog((Priority)Level.WARN, "TRANS_IMP_NOT_POSSIBLE", _args, null);
                }
            }
            node.setNextSibling(imp);
            imp.setPreviousSibling(node);
            imp.setParent(node);
            node = imp;
            ++i2;
        }
        node.setNextSibling(this._class);
    }

    private List decodeGroupingInfo(String info) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(info, DELIMETER_ENTRY);
        while (tokens.hasMoreElements()) {
            String pair = tokens.nextToken();
            String name = pair.substring(0, pair.indexOf(58));
            result.add(name);
        }
        return result;
    }

    private void expand() {
        List expandableImports = this.getExpandable(this._onDemandImports);
        ArrayList identifiers = new ArrayList(this._unqualIdents);
        identifiers.addAll(this._qualIdents);
        List expandedImports = this.expandImports(identifiers, this._singleTypeImports, expandableImports);
        expandedImports.addAll(this.removeObsoleteImports(this._singleTypeImports, this._qualIdents, this._unqualIdents));
        List unexpandedImports = this._onDemandImports;
        unexpandedImports.removeAll(expandableImports);
        this.updateTree(unexpandedImports, expandedImports);
    }

    private List expandImports(List identifiers_, List singleTypeImports, List expandableImports) {
        List identifiers = this.getPossibleSingleTypeImports(identifiers_, singleTypeImports);
        if (identifiers.isEmpty()) {
            return new ArrayList();
        }
        StringBuffer buf = new StringBuffer(50);
        String defaultPackageName = this._packageName;
        JavaNode template = (JavaNode)this._factory.create(35, EMPTY_STRING);
        Object[] repository = ClassRepository.getInstance().getContent();
        ArrayList<JavaNode> result = new ArrayList<JavaNode>(20);
        HashMap<String, JavaNode> conflicts = new HashMap<String, JavaNode>(20);
        int i = 0;
        int size = expandableImports.size();
        while (i < size) {
            int j = 0;
            int tempSize = identifiers.size();
            while (j < tempSize) {
                String unresolvedIdent = (String)identifiers.get(j);
                JavaNode resolvableImport = (JavaNode)expandableImports.get(i);
                buf.append(resolvableImport.getText());
                buf.append('.');
                buf.append(unresolvedIdent);
                template.setText(buf.toString());
                buf.setLength(0);
                if (Arrays.binarySearch(repository, template.getText()) > -1 && !singleTypeImports.contains(template) && !result.contains(template)) {
                    JavaNode node = (JavaNode)this._factory.create(35, template.getText());
                    node.setStartLine(resolvableImport.getStartLine());
                    node.setParent(resolvableImport.getParent());
                    node.setFirstChild(resolvableImport.getFirstChild());
                    node.setNextSibling(resolvableImport.getNextSibling());
                    node.setHiddenBefore(resolvableImport.getHiddenBefore());
                    node.setHiddenAfter(resolvableImport.getHiddenAfter());
                    resolvableImport.setHiddenBefore(null);
                    resolvableImport.setHiddenAfter(null);
                    JavaNode other = conflicts.put(unresolvedIdent, node);
                    if (other == null) {
                        result.add(node);
                    } else if (this.isDefaultPackage(node.getText(), defaultPackageName)) {
                        result.remove(other);
                        result.add(node);
                    } else if (!this.isDefaultPackage(node.getText(), defaultPackageName)) {
                        if (Loggers.TRANSFORM.isDebugEnabled()) {
                            Loggers.TRANSFORM.debug((Object)(this._filename + ":0:0: cannot expand due to unresolvable conflict -- " + node + " " + other));
                        }
                        return Collections.EMPTY_LIST;
                    }
                    int k = 0;
                    int s = this._qualIdents.size();
                    while (k < s) {
                        String name;
                        String type = (String)this._qualIdents.get(k);
                        if (node.getText().endsWith(type) && Arrays.binarySearch(repository, name = node.getText().substring(0, node.getText().indexOf(type)) + type.substring(0, type.lastIndexOf(46))) > -1) {
                            node.setText(name);
                            break;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        int size2 = result.size();
        while (i2 < size2) {
            JavaNode node = (JavaNode)result.get(i2);
            if (node.getStartLine() == -99) {
                result.remove(i2);
                --size2;
                --i2;
            } else if (this.isLangPackage(node.getText()) || this.isDefaultPackage(node.getText(), defaultPackageName)) {
                result.remove(i2);
                --size2;
                --i2;
            } else {
                ImportTransformation._args[0] = this._root.getText();
                ImportTransformation._args[1] = new Integer(node.getStartLine());
                ImportTransformation._args[2] = node.getText();
                Loggers.TRANSFORM.l7dlog((Priority)Level.INFO, "TRANS_IMP_EXPAND_ON_DEMAND", _args, null);
            }
            ++i2;
        }
        return result;
    }

    private List removeObsoleteImports(List singleTypeImports, List qualIdents, List unqualIdents) {
        ArrayList<JavaNode> result = new ArrayList<JavaNode>();
        String packageName = this._packageName;
        StringBuffer buf = new StringBuffer(100);
        int i = 0;
        int size = singleTypeImports.size();
        while (i < size) {
            JavaNode node = (JavaNode)singleTypeImports.get(i);
            if (this.isLangPackage(node.getText()) || this.isDefaultPackage(node.getText(), packageName)) {
                ImportTransformation._args[0] = this._root.getText();
                ImportTransformation._args[1] = new Integer(node.getStartLine());
                ImportTransformation._args[2] = node.getText();
                Loggers.TRANSFORM.l7dlog((Priority)Level.INFO, "TRANS_IMP_REMOVE_OBSOLETE", _args, null);
            } else {
                String path = StringHelper.getPackageName(node.getText());
                boolean furtherCheck = true;
                int j = 0;
                int s = qualIdents.size();
                block1: while (j < s) {
                    String type = (String)qualIdents.get(j);
                    int lastdot = type.lastIndexOf(46);
                    while (lastdot > -1) {
                        type = type.substring(0, lastdot);
                        buf.setLength(0);
                        buf.append(path);
                        buf.append('.');
                        buf.append(type);
                        if (node.getText().equals(buf.toString())) {
                            result.add(node);
                            furtherCheck = false;
                            break block1;
                        }
                        lastdot = type.lastIndexOf(46);
                    }
                    ++j;
                }
                if (furtherCheck) {
                    if (!unqualIdents.contains(StringHelper.getClassName(node.getText()))) {
                        ImportTransformation._args[0] = this._root.getText();
                        ImportTransformation._args[1] = new Integer(node.getStartLine());
                        ImportTransformation._args[2] = node.getText();
                        Loggers.TRANSFORM.l7dlog((Priority)Level.INFO, "TRANS_IMP_REMOVE_UNUSED", _args, null);
                    } else {
                        result.add(node);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    private void updateTree(List onDemandImports, List singleTypeImports) {
        ArrayList<JavaNode> imports = new ArrayList<JavaNode>(onDemandImports.size() + singleTypeImports.size());
        int i = 0;
        int size = onDemandImports.size();
        while (i < size) {
            JavaNode node = (JavaNode)onDemandImports.get(i);
            node.setText(node.getText() + ".*");
            imports.add(node);
            ++i;
        }
        imports.addAll(singleTypeImports);
        if (this._sortImports) {
            List info;
            this.COMP_IMPORT.identifiers = info = this.decodeGroupingInfo(Convention.getInstance().get(ConventionKeys.IMPORT_GROUPING, "*:0|gnu:2|java:2|javax:2"));
            Collections.sort(imports, this.COMP_IMPORT);
        } else {
            Collections.sort(imports, COMP_LINE);
        }
        this.createImportNodes(imports.toArray(EMPTY_NODE_ARRAY));
    }

    private static final class NodeStringComparator
    implements Comparator {
        private NodeStringComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            JavaNode n1 = (JavaNode)o1;
            JavaNode n2 = (JavaNode)o2;
            return n1.getText().compareTo(n2.getText());
        }
    }

    private static final class NodeOnDemandSingleComparator
    implements Comparator {
        private NodeOnDemandSingleComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            JavaNode packagePath = (JavaNode)o1;
            JavaNode importNode = (JavaNode)o2;
            return packagePath.getText().compareTo(StringHelper.getPackageName(importNode.getText()));
        }
    }

    private static final class NodeLineComparator
    implements Comparator {
        private NodeLineComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            JavaNode n1 = (JavaNode)o1;
            JavaNode n2 = (JavaNode)o2;
            if (n1.getStartLine() == n2.getStartLine()) {
                return n1.getText().compareTo(n2.getText());
            }
            if (n1.getStartLine() > n2.getStartLine()) {
                return 1;
            }
            if (n1.getStartLine() < n2.getStartLine()) {
                return -1;
            }
            return 0;
        }
    }

    private static final class ImportNodeComparator
    implements Comparator {
        List identifiers;

        private ImportNodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            JavaNode n1 = (JavaNode)o1;
            JavaNode n2 = (JavaNode)o2;
            int i1 = ImportTransformation.getIndex(this.identifiers, n1.getText());
            int i2 = ImportTransformation.getIndex(this.identifiers, n2.getText());
            if (i1 > -1) {
                if (i2 > -1) {
                    if (i1 > i2) {
                        return 1;
                    }
                    if (i2 > i1) {
                        return -1;
                    }
                } else {
                    i2 = ImportTransformation.getIndex(this.identifiers, ImportTransformation.STAR);
                    if (i1 > i2) {
                        return 1;
                    }
                    if (i2 > i1) {
                        return -1;
                    }
                }
            } else if (i2 > -1) {
                i1 = ImportTransformation.getIndex(this.identifiers, ImportTransformation.STAR);
                if (i1 > i2) {
                    return 1;
                }
                if (i2 > i1) {
                    return -1;
                }
            }
            return n1.getText().compareTo(n2.getText());
        }
    }
}

