/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MonitorRunner {
    private static final Log log = LogFactory.getLog((Class)MonitorRunner.class);
    private Collection monitors = new ArrayList();
    private boolean run = true;

    public MonitorRunner(final long interval) {
        try {
            Thread thread = new Thread("Monitor Runner"){

                public void run() {
                    while (MonitorRunner.this.run) {
                        try {
                            Thread.sleep(interval);
                            Iterator i = new ArrayList(MonitorRunner.this.monitors).iterator();
                            while (i.hasNext()) {
                                Runnable monitor = (Runnable)i.next();
                                try {
                                    monitor.run();
                                }
                                catch (Throwable t) {
                                    log.warn((Object)("Failed to run monitor: " + monitor));
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        catch (Exception e) {
            log.error((Object)"Unable to initialize Monitor Runner ", (Throwable)e);
        }
    }

    public void registerMonitor(Runnable monitor) {
        this.monitors.add(monitor);
    }

    public void unregisterMonitor(Runnable monitor) {
        this.monitors.remove(monitor);
    }

    public void stop() {
        this.run = false;
    }
}

