/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class UpdatedViews
implements Comparable {
    private final String iceFacesId;
    private final long sequenceNumber;
    private final Set updatedViewsSet;

    public UpdatedViews(String iceFacesId, long sequenceNumber, Set updatedViewsSet) {
        this.iceFacesId = iceFacesId;
        this.sequenceNumber = sequenceNumber;
        this.updatedViewsSet = updatedViewsSet;
    }

    public int compareTo(Object object) throws ClassCastException {
        if (!(object instanceof UpdatedViews)) {
            throw new ClassCastException("object is not an instance of UpdatedViews");
        }
        UpdatedViews _updatedViews = (UpdatedViews)object;
        int _result = this.iceFacesId.compareTo(_updatedViews.iceFacesId);
        if (_result != 0) {
            return _result;
        }
        if (this.sequenceNumber < _updatedViews.sequenceNumber) {
            return -1;
        }
        if (this.sequenceNumber > _updatedViews.sequenceNumber) {
            return 1;
        }
        return 0;
    }

    public boolean contains(String viewNumber) {
        return this.updatedViewsSet.contains(viewNumber);
    }

    public String getICEfacesID() {
        return this.iceFacesId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Set getUpdatedViewsSet() {
        return Collections.unmodifiableSet(this.updatedViewsSet);
    }

    public static UpdatedViews merge(UpdatedViews updatedViews1, UpdatedViews updatedViews2) {
        UpdatedViews _updatedViews;
        if (!updatedViews1.iceFacesId.equals(updatedViews2.iceFacesId)) {
            _updatedViews = null;
        } else {
            HashSet _updatedViewsSet = new HashSet(updatedViews1.updatedViewsSet);
            _updatedViewsSet.addAll(updatedViews2.updatedViewsSet);
            _updatedViews = new UpdatedViews(updatedViews1.iceFacesId, Math.max(updatedViews1.sequenceNumber, updatedViews2.sequenceNumber), _updatedViewsSet);
        }
        return _updatedViews;
    }

    public boolean remove(String viewNumber) {
        return this.updatedViewsSet.remove(viewNumber);
    }

    public int size() {
        return this.updatedViewsSet.size();
    }

    public String toString() {
        StringBuffer _string = new StringBuffer();
        _string.append("UpdatedViews [ICEfaces ID: ").append(this.iceFacesId).append(", Sequence Number: ").append(this.sequenceNumber).append(", View Numbers: ");
        int _size = this.updatedViewsSet.size();
        Iterator _updatedViewsIterator = this.updatedViewsSet.iterator();
        for (int i = 0; i < _size; ++i) {
            if (i != 0) {
                _string.append(", ");
            }
            _string.append(_updatedViewsIterator.next());
        }
        _string.append("]");
        return _string.toString();
    }
}

