/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.net.messaging.jms;

import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.ObjectMessage;
import com.icesoft.net.messaging.TextMessage;
import com.icesoft.net.messaging.jms.AbstractJMSConnection;
import com.icesoft.net.messaging.jms.JMSAdapter;
import com.icesoft.net.messaging.jms.JMSConnection;
import java.util.Enumeration;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSPublisherConnection
extends AbstractJMSConnection
implements JMSConnection {
    private static final Log LOG = LogFactory.getLog((Class)JMSPublisherConnection.class);
    private TopicPublisher topicPublisher;

    public JMSPublisherConnection(Topic topic, JMSAdapter jmsAdapter) throws IllegalArgumentException {
        super(topic, jmsAdapter, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (this.connected) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connected) {
                    JMSException _jmsException;
                    block11: {
                        _jmsException = null;
                        if (this.topicPublisher != null) {
                            try {
                                this.topicPublisher.close();
                            }
                            catch (JMSException exception) {
                                _jmsException = exception;
                            }
                        }
                        try {
                            super.close();
                        }
                        catch (JMSException exception) {
                            if (_jmsException != null) break block11;
                            _jmsException = exception;
                        }
                    }
                    this.topicPublisher = null;
                    if (_jmsException != null) {
                        throw _jmsException;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Message message) throws InvalidDestinationException, JMSException, MessageFormatException, UnsupportedOperationException {
        if (message != null && this.connected) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connected) {
                    if (this.topicPublisher == null) {
                        this.topicPublisher = this.topicSession.createPublisher(this.topic);
                        this.topicPublisher.setDeliveryMode(1);
                    }
                    javax.jms.Message _message = this.createMessage(message);
                    this.topicPublisher.publish(_message);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[" + this.jmsAdapter.getMessageServiceClient().getName() + "] Outgoing message:\r\n\r\n" + JMSPublisherConnection.toString(_message)));
                    }
                }
            }
        }
    }

    private javax.jms.Message createMessage(Message message) throws JMSException {
        if (message instanceof ObjectMessage) {
            return this.createObjectMessage((ObjectMessage)message);
        }
        if (message instanceof TextMessage) {
            return this.createTextMessage((TextMessage)message);
        }
        return null;
    }

    private javax.jms.ObjectMessage createObjectMessage(ObjectMessage objectMessage) throws JMSException {
        javax.jms.ObjectMessage _objectMessage = this.topicSession.createObjectMessage(objectMessage.getObject());
        Enumeration _propertyNames = objectMessage.getPropertyNames();
        while (_propertyNames.hasMoreElements()) {
            String _propertyName = (String)_propertyNames.nextElement();
            _objectMessage.setObjectProperty(_propertyName, objectMessage.getObjectProperty(_propertyName));
        }
        return _objectMessage;
    }

    private javax.jms.TextMessage createTextMessage(TextMessage textMessage) throws JMSException {
        javax.jms.TextMessage _textMessage = this.topicSession.createTextMessage(textMessage.getText());
        Enumeration _propertyNames = textMessage.getPropertyNames();
        while (_propertyNames.hasMoreElements()) {
            String _propertyName = (String)_propertyNames.nextElement();
            _textMessage.setObjectProperty(_propertyName, textMessage.getObjectProperty(_propertyName));
        }
        return _textMessage;
    }
}

