/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.securechannel;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.securechannel.ChannelEntryPoint;
import org.springframework.security.util.PortMapper;
import org.springframework.security.util.PortMapperImpl;
import org.springframework.security.util.PortResolver;
import org.springframework.security.util.PortResolverImpl;
import org.springframework.util.Assert;

public abstract class AbstractRetryEntryPoint
implements ChannelEntryPoint {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$securechannel$RetryWithHttpEntryPoint == null ? (class$org$springframework$security$securechannel$RetryWithHttpEntryPoint = AbstractRetryEntryPoint.class$("org.springframework.security.securechannel.RetryWithHttpEntryPoint")) : class$org$springframework$security$securechannel$RetryWithHttpEntryPoint));
    private PortMapper portMapper = new PortMapperImpl();
    private PortResolver portResolver = new PortResolverImpl();
    private String scheme;
    private int standardPort;
    static /* synthetic */ Class class$org$springframework$security$securechannel$RetryWithHttpEntryPoint;

    public AbstractRetryEntryPoint(String scheme, int standardPort) {
        this.scheme = scheme;
        this.standardPort = standardPort;
    }

    public void commence(ServletRequest req, ServletResponse res) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String pathInfo = request.getPathInfo();
        String queryString = request.getQueryString();
        String contextPath = request.getContextPath();
        String destination = request.getServletPath() + (pathInfo == null ? "" : pathInfo) + (queryString == null ? "" : "?" + queryString);
        String redirectUrl = contextPath;
        Integer currentPort = new Integer(this.portResolver.getServerPort((ServletRequest)request));
        Integer redirectPort = this.getMappedPort(currentPort);
        if (redirectPort != null) {
            boolean includePort = redirectPort != this.standardPort;
            redirectUrl = this.scheme + request.getServerName() + (includePort ? ":" + redirectPort : "") + contextPath + destination;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Redirecting to: " + redirectUrl));
        }
        ((HttpServletResponse)res).sendRedirect(((HttpServletResponse)res).encodeRedirectURL(redirectUrl));
    }

    protected abstract Integer getMappedPort(Integer var1);

    protected PortMapper getPortMapper() {
        return this.portMapper;
    }

    protected PortResolver getPortResolver() {
        return this.portResolver;
    }

    public void setPortMapper(PortMapper portMapper) {
        Assert.notNull((Object)portMapper, (String)"portMapper cannot be null");
        this.portMapper = portMapper;
    }

    public void setPortResolver(PortResolver portResolver) {
        Assert.notNull((Object)portResolver, (String)"portResolver cannot be null");
        this.portResolver = portResolver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

