/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.rcp;

import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.rcp.RemoteAuthenticationException;
import org.acegisecurity.providers.rcp.RemoteAuthenticationManager;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RemoteAuthenticationManagerImpl
implements RemoteAuthenticationManager,
InitializingBean {
    private AuthenticationManager authenticationManager;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager is required");
    }

    public GrantedAuthority[] attemptAuthentication(String username, String password) throws RemoteAuthenticationException {
        UsernamePasswordAuthenticationToken request = new UsernamePasswordAuthenticationToken(username, password);
        try {
            return this.authenticationManager.authenticate(request).getAuthorities();
        }
        catch (AuthenticationException authEx) {
            throw new RemoteAuthenticationException(authEx.getMessage());
        }
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

