/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.geom.Point2D;
import org.krysalis.jcharts.chartData.ScatterPlotDataSet;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.LabelAxisProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.util.ChartFont;
import org.krysalis.jcharts.properties.util.ChartStroke;

public final class TestDataGenerator {
    private static final Font[] ALL_FONTS = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();

    public static Font getRandomFont(double d, double d2) {
        Font font = ALL_FONTS[(int)TestDataGenerator.getRandomNumber(ALL_FONTS.length)];
        font = font.deriveFont((float)TestDataGenerator.getRandomNumber(d, d2));
        return font;
    }

    public static double getRandomNumber(double d) {
        return Math.random() * d;
    }

    protected static double getRandomNumber(double d, double d2) {
        return d + Math.random() * (d2 - d);
    }

    protected static double getRandomNumberIncludingZero(double d, double d2) {
        if (TestDataGenerator.getRandomNumber(1.0) > 0.8) {
            return 0.0;
        }
        return TestDataGenerator.getRandomNumber(d, d2);
    }

    public static double[] getRandomNumbers(int n, double d, double d2) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = TestDataGenerator.getRandomNumber(d, d2);
        }
        return dArray;
    }

    public static double[][] getRandomNumbers(int n, int n2, double d, double d2) {
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = TestDataGenerator.getRandomNumberIncludingZero(d, d2);
            }
        }
        return dArray;
    }

    public static Point2D.Double[] getRandomPoints(int n, double d, double d2, double d3, double d4) {
        Point2D.Double[] doubleArray = new Point2D.Double[n];
        for (int i = 0; i < n; ++i) {
            doubleArray[i] = ScatterPlotDataSet.createPoint2DDouble();
            doubleArray[i].setLocation(TestDataGenerator.getRandomNumber(d, d2), TestDataGenerator.getRandomNumber(d3, d4));
        }
        return doubleArray;
    }

    protected static Paint getRandomPaint() {
        if (TestDataGenerator.getRandomNumber(1.0) > 0.5) {
            return TestDataGenerator.getRandomColor();
        }
        float f = (float)TestDataGenerator.getRandomNumber(10.0, 800.0);
        float f2 = (float)TestDataGenerator.getRandomNumber(10.0, 600.0);
        float f3 = (float)TestDataGenerator.getRandomNumber(0.0, 800.0);
        float f4 = (float)TestDataGenerator.getRandomNumber(0.0, 600.0);
        return new GradientPaint(f3, f4, TestDataGenerator.getRandomColor(), f, f2, TestDataGenerator.getRandomColor());
    }

    public static Paint[] getRandomPaints(int n) {
        Paint[] paintArray = new Paint[n];
        for (int i = 0; i < n; ++i) {
            paintArray[i] = TestDataGenerator.getRandomPaint();
        }
        return paintArray;
    }

    protected static Color getRandomColor() {
        int n = (int)TestDataGenerator.getRandomNumber(100.0, 375.0);
        if (n > 255) {
            n = 255;
        }
        return new Color((int)TestDataGenerator.getRandomNumber(255.0), (int)TestDataGenerator.getRandomNumber(255.0), (int)TestDataGenerator.getRandomNumber(255.0), n);
    }

    protected static String getRandomString(int n, boolean bl) {
        if (bl && TestDataGenerator.getRandomNumber(10.0) <= 1.0) {
            return null;
        }
        int n2 = 1 + (int)TestDataGenerator.getRandomNumber(n);
        StringBuffer stringBuffer = new StringBuffer(n2);
        while (n2-- > 0) {
            int n3 = 65 + (int)TestDataGenerator.getRandomNumber(58.0);
            while (n3 > 90 && n3 < 97) {
                n3 = 65 + (int)TestDataGenerator.getRandomNumber(58.0);
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    protected static String[] getRandomStrings(int n, int n2, boolean bl) {
        if (bl && (int)TestDataGenerator.getRandomNumber(10.0) <= 1) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = TestDataGenerator.getRandomString(n2, false);
        }
        return stringArray;
    }

    protected static void randomizeAxisProperties(AxisProperties axisProperties) {
        LabelAxisProperties labelAxisProperties;
        DataAxisProperties dataAxisProperties;
        if (axisProperties.isPlotHorizontal()) {
            dataAxisProperties = (DataAxisProperties)axisProperties.getXAxisProperties();
            labelAxisProperties = (LabelAxisProperties)axisProperties.getYAxisProperties();
        } else {
            dataAxisProperties = (DataAxisProperties)axisProperties.getYAxisProperties();
            labelAxisProperties = (LabelAxisProperties)axisProperties.getXAxisProperties();
        }
        dataAxisProperties.setNumItems((int)TestDataGenerator.getRandomNumber(2.0, 15.0));
        dataAxisProperties.setRoundToNearest((int)TestDataGenerator.getRandomNumber(-5.0, 3.0));
        dataAxisProperties.setUseDollarSigns(TestDataGenerator.getRandomNumber(1.0) > 0.5);
        dataAxisProperties.setUseCommas(TestDataGenerator.getRandomNumber(1.0) > 0.5);
        dataAxisProperties.setShowEndBorder(TestDataGenerator.getRandomNumber(1.0) > 0.5);
        labelAxisProperties.setShowEndBorder(TestDataGenerator.getRandomNumber(1.0) > 0.5);
        axisProperties.getXAxisProperties().setAxisStroke(new ChartStroke(new BasicStroke(1.5f), TestDataGenerator.getRandomPaint()));
        axisProperties.getYAxisProperties().setAxisStroke(new ChartStroke(new BasicStroke(1.5f), TestDataGenerator.getRandomPaint()));
    }

    protected static void randomizeLegend(LegendProperties legendProperties) {
        int n = (int)TestDataGenerator.getRandomNumber(1.0, 6.0);
        if (n == 6) {
            n = 0;
        }
        legendProperties.setNumColumns(n);
        legendProperties.setPlacement((int)TestDataGenerator.getRandomNumber(4.0));
        int n2 = (int)TestDataGenerator.getRandomNumber(6.0, 20.0);
        Font font = ALL_FONTS[(int)TestDataGenerator.getRandomNumber(ALL_FONTS.length)];
        font = font.deriveFont((float)n2);
        legendProperties.setChartFont(new ChartFont(font, TestDataGenerator.getRandomPaint()));
        if ((int)TestDataGenerator.getRandomNumber(2.0) == 0) {
            legendProperties.setBorderStroke(null);
        } else {
            legendProperties.setBorderStroke(ChartStroke.DEFAULT_LEGEND_OUTLINE);
        }
        if ((int)TestDataGenerator.getRandomNumber(2.0) == 0) {
            legendProperties.setBackgroundPaint(null);
        } else {
            legendProperties.setBackgroundPaint(TestDataGenerator.getRandomPaint());
        }
    }
}

