/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.util.impl;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceContextFromDOM
implements NamespaceContext {
    private Element element;

    NamespaceContextFromDOM(Element element) {
        this.element = element;
    }

    public String getPrefix(String namespaceURI) {
        return this.element.lookupPrefix(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (this.element instanceof SOAPElement) {
            Iterator it = ((SOAPElement)this.element).getVisibleNamespacePrefixes();
            ArrayList<String> list = new ArrayList<String>();
            while (it.hasNext()) {
                String prefix = (String)it.next();
                if (!this.getNamespaceURI(prefix).equals(namespaceURI)) continue;
                if (prefix != null && prefix.length() == 0) {
                    prefix = null;
                }
                list.add(prefix);
            }
            return list.iterator();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Node node = this.element; node != null; node = node.getParentNode()) {
            if (!(node instanceof Element)) continue;
            NamedNodeMap attrs = node.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String name;
                Attr attr = (Attr)attrs.item(i);
                if (!attr.getNodeValue().equals(namespaceURI) || !(name = attr.getNodeName()).startsWith("xmlns")) continue;
                String prefix = "";
                if (name.startsWith("xmlns:")) {
                    prefix = name.substring(6);
                }
                if (list.contains(prefix) || !this.getNamespaceURI(prefix).equals(namespaceURI)) continue;
                list.add(prefix);
            }
        }
        return list.iterator();
    }

    public String getNamespaceURI(String prefix) {
        return this.element.lookupNamespaceURI(prefix);
    }
}

