/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;

public class SchemaUtil {
    private static final Log log = LogFactory.getLog(SchemaUtil.class);

    public static XmlSchema[] getAllSchemas(XmlSchema schema) {
        HashMap map = new HashMap();
        SchemaUtil.traverseSchemas(schema, map);
        return map.values().toArray(new XmlSchema[map.values().size()]);
    }

    private static void traverseSchemas(XmlSchema schema, HashMap map) {
        String key = schema.getTargetNamespace() + ":" + schema.getSourceURI();
        if (map.containsKey(key)) {
            return;
        }
        map.put(key, schema);
        XmlSchemaObjectCollection includes = schema.getIncludes();
        if (includes != null) {
            Iterator tempIterator = includes.getIterator();
            while (tempIterator.hasNext()) {
                XmlSchema schema1;
                Object o = tempIterator.next();
                if (o instanceof XmlSchemaImport && (schema1 = ((XmlSchemaImport)o).getSchema()) != null) {
                    SchemaUtil.traverseSchemas(schema1, map);
                }
                if (!(o instanceof XmlSchemaInclude) || (schema1 = ((XmlSchemaInclude)o).getSchema()) == null) continue;
                SchemaUtil.traverseSchemas(schema1, map);
            }
        }
    }
}

