/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.chartData.interfaces.IAxisChartDataSet;
import org.krysalis.jcharts.chartData.interfaces.IDataSeries;
import org.krysalis.jcharts.imageMap.CircleMapArea;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.PointChartProperties;

abstract class PointChart {
    PointChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) {
        int n;
        Graphics2D graphics2D = axisChart.getGraphics2D();
        PointChartProperties pointChartProperties = (PointChartProperties)iAxisChartDataSet.getChartTypeProperties();
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getYAxisProperties();
        IDataSeries iDataSeries = (IDataSeries)axisChart.getIAxisDataSeries();
        float f = axisChart.getXAxis().getTickStart();
        double[] dArray = new double[iAxisChartDataSet.getNumberOfDataSets()];
        double[] dArray2 = new double[iAxisChartDataSet.getNumberOfDataSets()];
        AffineTransform affineTransform = graphics2D.getTransform();
        for (n = 0; n < iAxisChartDataSet.getNumberOfDataSets(); ++n) {
            Rectangle2D rectangle2D = pointChartProperties.getShape(n).getBounds2D();
            dArray[n] = rectangle2D.getWidth() / 2.0;
            dArray2[n] = rectangle2D.getHeight() / 2.0;
        }
        graphics2D.setStroke(PointChartProperties.DEFAULT_POINT_BORDER_STROKE);
        for (n = 0; n < iAxisChartDataSet.getNumberOfDataItems(); ++n) {
            for (int i = 0; i < iAxisChartDataSet.getNumberOfDataSets(); ++i) {
                if (Double.isNaN(iAxisChartDataSet.getValue(i, n))) continue;
                float f2 = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iAxisChartDataSet.getValue(i, n), axisChart.getYAxis().getScaleCalculator().getMinValue());
                if (axisChart.getGenerateImageMapFlag()) {
                    String string = axisChart.getXAxis().getAxisLabelsGroup() != null ? axisChart.getXAxis().getAxisLabelsGroup().getTextTag(n).getText() : null;
                    axisChart.getImageMap().addImageMapArea(new CircleMapArea(f, f2, iAxisChartDataSet.getValue(i, n), string, iAxisChartDataSet.getLegendLabel(i)));
                }
                graphics2D.translate((double)f - dArray[i], (double)f2 - dArray2[i]);
                graphics2D.setPaint(iAxisChartDataSet.getPaint(i));
                if (pointChartProperties.getFillPointsFlag(i)) {
                    graphics2D.fill(pointChartProperties.getShape(i));
                    if (pointChartProperties.getPointOutlinePaints(i) != null) {
                        graphics2D.setPaint(pointChartProperties.getPointOutlinePaints(i));
                        graphics2D.draw(pointChartProperties.getShape(i));
                    }
                } else {
                    graphics2D.draw(pointChartProperties.getShape(i));
                }
                graphics2D.setTransform(affineTransform);
            }
            f += axisChart.getXAxis().getScalePixelWidth();
        }
    }
}

