/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.nonAxisChart;

import java.awt.font.FontRenderContext;
import org.krysalis.jcharts.chartData.interfaces.IPieChartDataSet;
import org.krysalis.jcharts.chartText.NumericTagGroup;
import org.krysalis.jcharts.chartText.TextTag;
import org.krysalis.jcharts.chartText.TextTagGroup;
import org.krysalis.jcharts.properties.PieChart2DProperties;
import org.krysalis.jcharts.types.PieLabelType;

class PieLabels {
    private TextTagGroup textTagGroup;
    private float widestLabel;
    private float widestLabelTimesTwo;
    private float tallestLabel;
    private float tallestLabelTimesTwo;

    PieLabels(PieChart2DProperties pieChart2DProperties, IPieChartDataSet iPieChartDataSet, FontRenderContext fontRenderContext) {
        if (!pieChart2DProperties.getPieLabelType().equals(PieLabelType.NO_LABELS)) {
            if (pieChart2DProperties.getPieLabelType().equals(PieLabelType.VALUE_LABELS)) {
                this.textTagGroup = new NumericTagGroup(pieChart2DProperties.getValueLabelFont(), fontRenderContext, pieChart2DProperties.showValueLabelCurrency(), false, pieChart2DProperties.showValueLabelGrouping(), pieChart2DProperties.getValueLabelRoundingPowerOfTen());
                for (int i = 0; i < iPieChartDataSet.getNumberOfDataItems(); ++i) {
                    ((NumericTagGroup)this.textTagGroup).addLabel(iPieChartDataSet.getValue(i));
                }
            } else {
                this.textTagGroup = new TextTagGroup(pieChart2DProperties.getValueLabelFont(), fontRenderContext);
                for (int i = 0; i < iPieChartDataSet.getNumberOfLegendLabels(); ++i) {
                    this.textTagGroup.addLabel(iPieChartDataSet.getLegendLabel(i));
                }
            }
            this.widestLabel = this.textTagGroup.getWidestLabel();
            this.widestLabelTimesTwo = this.widestLabel * 2.0f;
            this.tallestLabel = this.textTagGroup.getTallestLabel();
            this.tallestLabelTimesTwo = this.tallestLabel * 2.0f;
        }
    }

    public TextTag getTextTag(int n) {
        return this.textTagGroup.getTextTag(n);
    }

    public float getWidestLabelTimesTwo() {
        return this.widestLabelTimesTwo;
    }

    public float getWidestLabel() {
        return this.widestLabel;
    }

    public float getTallestLabel() {
        return this.tallestLabel;
    }

    public float getTallestLabelTimesTwo() {
        return this.tallestLabelTimesTwo;
    }
}

