/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputchart;

import com.icesoft.faces.component.outputchart.AbstractChart;
import com.icesoft.faces.component.outputchart.OutputChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import javax.faces.component.UIComponent;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.chartData.PieChartDataSet;
import org.krysalis.jcharts.chartData.interfaces.IPieChartDataSet;
import org.krysalis.jcharts.nonAxisChart.PieChart2D;
import org.krysalis.jcharts.nonAxisChart.PieChart3D;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.PieChart2DProperties;
import org.krysalis.jcharts.properties.PieChart3DProperties;
import org.krysalis.jcharts.properties.util.ChartStroke;
import org.krysalis.jcharts.types.PieLabelType;

public class PieChart
extends AbstractChart {
    double[] data = null;
    String[] labels = null;

    public PieChart(UIComponent outputChart) throws Throwable {
        super(outputChart);
    }

    protected void buildChart(OutputChart outputChart) {
        try {
            if (outputChart.getType().equalsIgnoreCase("pie2d")) {
                this.chart = this.getPie2dChart(outputChart);
            } else if (outputChart.getType().equalsIgnoreCase("pie3d")) {
                this.chart = this.getPie3dChart(outputChart);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public double[] getData(Object obj) {
        if (this.data != null && obj instanceof String) {
            return this.data;
        }
        this.data = super.getAsDoubleArray(obj);
        return this.data;
    }

    public String[] getLabels(Object obj) {
        if (obj == null && this.labels == null) {
            this.labels = this.getGeneratedLabels("label", this.data.length);
            return this.labels;
        }
        if ((obj == null || obj instanceof String) && this.labels != null) {
            return this.labels;
        }
        this.labels = this.getAsStringArray(obj);
        return this.labels;
    }

    public Paint[] getPaints(Object obj) {
        return this.getPaints(obj, this.data.length);
    }

    private Chart getPie2dChart(OutputChart outputChart) throws Throwable {
        PieChart2DProperties pieChart2DProperties = new PieChart2DProperties();
        PieChartDataSet pieChartDataSet = new PieChartDataSet(outputChart.getChartTitle(), this.getData(outputChart.getData()), this.getLabels(outputChart.getLabels()), this.getPaints(outputChart.getColors()), pieChart2DProperties);
        return new PieChart2D((IPieChartDataSet)pieChartDataSet, this.getLegendProperties(outputChart), new ChartProperties(), new Integer(outputChart.getWidth()).intValue(), new Integer(outputChart.getHeight()).intValue());
    }

    private Chart getPie3dChart(OutputChart outputChart) throws Throwable {
        PieChart3DProperties pieChart3DProperties = new PieChart3DProperties();
        pieChart3DProperties.setDepth(30);
        pieChart3DProperties.setBorderChartStroke(new ChartStroke((Stroke)new BasicStroke(1.0f), (Paint)Color.black));
        pieChart3DProperties.setPieLabelType(PieLabelType.LEGEND_LABELS);
        PieChartDataSet pieChartDataSet = new PieChartDataSet(outputChart.getChartTitle(), this.getData(outputChart.getData()), this.getLabels(outputChart.getLabels()), this.getPaints(outputChart.getColors()), (PieChart2DProperties)pieChart3DProperties);
        return new PieChart3D((IPieChartDataSet)pieChartDataSet, null, new ChartProperties(), new Integer(outputChart.getWidth()).intValue(), new Integer(outputChart.getHeight()).intValue());
    }
}

