/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.web;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.RequestKey;
import org.springframework.security.util.AntUrlPathMatcher;
import org.springframework.security.util.RegexUrlPathMatcher;
import org.springframework.security.util.StringSplitUtils;
import org.springframework.security.util.UrlMatcher;
import org.springframework.util.StringUtils;

public class FilterInvocationDefinitionSourceEditor
extends PropertyEditorSupport {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$intercept$web$FilterInvocationDefinitionSourceEditor == null ? (class$org$springframework$security$intercept$web$FilterInvocationDefinitionSourceEditor = FilterInvocationDefinitionSourceEditor.class$("org.springframework.security.intercept.web.FilterInvocationDefinitionSourceEditor")) : class$org$springframework$security$intercept$web$FilterInvocationDefinitionSourceEditor));
    public static final String DIRECTIVE_CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON = "CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON";
    public static final String DIRECTIVE_PATTERN_TYPE_APACHE_ANT = "PATTERN_TYPE_APACHE_ANT";
    static /* synthetic */ Class class$org$springframework$security$intercept$web$FilterInvocationDefinitionSourceEditor;

    public void setAsText(String s) throws IllegalArgumentException {
        boolean converUrlToLowerCase;
        if (s == null || "".equals(s)) {
            this.setValue(new DefaultFilterInvocationDefinitionSource(new RegexUrlPathMatcher()));
            return;
        }
        boolean useAnt = s.lastIndexOf(DIRECTIVE_PATTERN_TYPE_APACHE_ANT) != -1;
        boolean bl = converUrlToLowerCase = s.lastIndexOf(DIRECTIVE_CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON) != -1;
        if (logger.isDebugEnabled()) {
            if (useAnt) {
                logger.debug((Object)"Detected PATTERN_TYPE_APACHE_ANT directive; using Apache Ant style path expressions");
            }
            if (converUrlToLowerCase && logger.isDebugEnabled()) {
                logger.debug((Object)"Detected CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON directive; Instructing mapper to convert URLs to lowercase before comparison");
            }
        }
        BufferedReader br = new BufferedReader(new StringReader(s));
        int counter = 0;
        LinkedHashMap<RequestKey, ConfigAttributeDefinition> urlMap = new LinkedHashMap<RequestKey, ConfigAttributeDefinition>();
        while (true) {
            String line;
            ++counter;
            try {
                line = br.readLine();
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe.getMessage());
            }
            if (line == null) break;
            line = line.trim();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Line " + counter + ": " + line));
            }
            if (line.startsWith("//")) continue;
            if (line.lastIndexOf(DIRECTIVE_CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON) != -1 && (line.lastIndexOf(DIRECTIVE_PATTERN_TYPE_APACHE_ANT) != -1 || line.lastIndexOf("=") != -1)) {
                throw new IllegalArgumentException("Line appears to be malformed: " + line);
            }
            if (line.lastIndexOf(DIRECTIVE_PATTERN_TYPE_APACHE_ANT) != -1 && (line.lastIndexOf(DIRECTIVE_CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON) != -1 || line.lastIndexOf("=") != -1)) {
                throw new IllegalArgumentException("Line appears to be malformed: " + line);
            }
            if (line.lastIndexOf(61) == -1) continue;
            if (line.lastIndexOf("==") != -1) {
                throw new IllegalArgumentException("Only single equals should be used in line " + line);
            }
            String name = StringSplitUtils.substringBeforeLast(line, "=");
            String value = StringSplitUtils.substringAfterLast(line, "=");
            if (!StringUtils.hasText((String)name) || !StringUtils.hasText((String)value)) {
                throw new IllegalArgumentException("Failed to parse a valid name/value pair from " + line);
            }
            if (converUrlToLowerCase && useAnt) {
                for (int i = 0; i < name.length(); ++i) {
                    String character = name.substring(i, i + 1);
                    if (character.toLowerCase().equals(character)) continue;
                    throw new IllegalArgumentException("You are using the CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON with Ant Paths, yet you have specified an uppercase character in line: " + line + " (character '" + character + "')");
                }
            }
            String[] tokens = StringUtils.commaDelimitedListToStringArray((String)value);
            urlMap.put(new RequestKey(name), new ConfigAttributeDefinition(tokens));
        }
        DefaultFilterInvocationDefinitionSource fids = new DefaultFilterInvocationDefinitionSource(this.createMatcher(useAnt, converUrlToLowerCase), urlMap);
        if (useAnt) {
            fids.setStripQueryStringFromUrls(true);
        }
        this.setValue(fids);
    }

    private UrlMatcher createMatcher(boolean useAnt, boolean converUrlToLowerCase) {
        UrlMatcher matcher;
        if (useAnt) {
            matcher = new AntUrlPathMatcher();
            ((AntUrlPathMatcher)matcher).setRequiresLowerCaseUrl(converUrlToLowerCase);
        } else {
            matcher = new RegexUrlPathMatcher();
            ((RegexUrlPathMatcher)matcher).setRequiresLowerCaseUrl(converUrlToLowerCase);
        }
        return matcher;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

