/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.Iterator;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;

public class SessionUtils {
    public static String calculateMaxScopeForServiceGroup(AxisServiceGroup axisServiceGroup) {
        Iterator<AxisService> servics = axisServiceGroup.getServices();
        int maxScope = 1;
        while (servics.hasNext()) {
            AxisService axisService = servics.next();
            int scopeIntValue = SessionUtils.getScopeIntValue(axisService.getScope());
            if (maxScope >= scopeIntValue) continue;
            maxScope = scopeIntValue;
        }
        return SessionUtils.getScopeString(maxScope);
    }

    private static int getScopeIntValue(String scope) {
        if ("request".equals(scope)) {
            return 1;
        }
        if ("transportsession".equals(scope)) {
            return 2;
        }
        if ("soapsession".equals(scope)) {
            return 3;
        }
        if ("application".equals(scope)) {
            return 4;
        }
        return 2;
    }

    private static String getScopeString(int scope) {
        switch (scope) {
            case 1: {
                return "request";
            }
            case 2: {
                return "transportsession";
            }
            case 3: {
                return "soapsession";
            }
            case 4: {
                return "application";
            }
        }
        return "transportsession";
    }
}

