/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.xpointer;

public class InvalidXPointerException
extends Exception {
    private static final long serialVersionUID = 0L;
    private final String fragment;
    private final Integer startChar;
    private final Integer endChar;

    public InvalidXPointerException(String message, String fragment) {
        this(message, fragment, null, null, null);
    }

    public InvalidXPointerException(String message, String fragment, Throwable cause) {
        this(message, fragment, null, null, cause);
    }

    public InvalidXPointerException(String message, String fragment, int startChar, int endChar) {
        this(message, fragment, new Integer(startChar), new Integer(endChar), (Throwable)null);
    }

    public InvalidXPointerException(String message, String fragment, int startChar, int endChar, Throwable cause) {
        this(message, fragment, new Integer(startChar), new Integer(endChar), cause);
    }

    private InvalidXPointerException(String message, String fragment, Integer startChar, Integer endChar, Throwable cause) {
        super(message, cause);
        this.fragment = fragment;
        this.startChar = startChar;
        this.endChar = endChar;
    }

    public String getFragment() {
        return this.fragment;
    }

    public Integer getStartChar() {
        return this.startChar;
    }

    public Integer getEndChar() {
        return this.endChar;
    }

    public String toString() {
        String postString = this.startChar != null && this.endChar != null ? "{XPointer: " + this.fragment + ", start: " + this.startChar.toString() + ", end: " + this.endChar.toString() + ", substr: " + this.fragment.substring(this.startChar, this.endChar) + "}" : "{XPointer: " + this.fragment + "}";
        return "InvalidXPointerException: " + this.getMessage() + ". " + postString;
    }
}

