/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.paneldivider;

import com.icesoft.faces.component.ExtendedAttributeConstants;
import com.icesoft.faces.component.paneldivider.PanelDivider;
import com.icesoft.faces.component.util.CustomComponentUtils;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PanelDividerRenderer
extends DomBasicRenderer {
    private static final String[] PASSTHRU_EXCLUDE = new String[]{"style"};
    private static final String[] PASSTHRU = ExtendedAttributeConstants.getAttributes(56, PASSTHRU_EXCLUDE);

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        PanelDividerRenderer.validateParameters((FacesContext)facesContext, (UIComponent)uiComponent, (Class)PanelDivider.class);
        PanelDivider panelDivider = (PanelDivider)uiComponent;
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        if (!domContext.isInitialized()) {
            Element container = domContext.createRootElement("div");
            PanelDividerRenderer.setRootElementId((FacesContext)facesContext, (Element)container, (UIComponent)uiComponent);
        }
        Element root = (Element)domContext.getRootNode();
        Element container = domContext.createElement("div");
        root.appendChild(container);
        container.setAttribute("class", panelDivider.getContainerClass());
        String style = panelDivider.getStyle();
        if (style != null) {
            root.setAttribute("style", style);
        }
        Element dividerContainer = domContext.createElement("div");
        root.setAttribute("class", panelDivider.getStyleClass());
        dividerContainer.setAttribute("class", panelDivider.getSplitterClass());
        if (panelDivider.isHorizontal()) {
            dividerContainer.setAttribute("onmousedown", "new Ice.PanelDivider(event, true);");
        } else {
            dividerContainer.setAttribute("onmousedown", "new Ice.PanelDivider(event);");
        }
        String clientId = uiComponent.getClientId(facesContext);
        dividerContainer.appendChild(domContext.createTextNode("&nbsp;"));
        this.renderPane(facesContext, uiComponent, true);
        container.appendChild(dividerContainer);
        dividerContainer.setAttribute("id", ClientIdPool.get((String)(clientId + "Divider")));
        this.renderPane(facesContext, uiComponent, false);
        this.addHiddenField(domContext, root, clientId, "FirstPane", panelDivider.getPanePosition(true));
        this.addHiddenField(domContext, root, clientId, "SecondPane", panelDivider.getPanePosition(false));
        this.addHiddenField(domContext, root, clientId, "InPercent", "");
        domContext.stepOver();
        JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)("Ice.PanelDivider.onLoad('" + clientId + "Divider', " + panelDivider.isHorizontal() + ");"));
    }

    void renderPane(FacesContext facesContext, UIComponent uiComponent, boolean isFrist) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        PanelDivider panelDivider = (PanelDivider)uiComponent;
        String clientId = uiComponent.getClientId(facesContext);
        Element pane = domContext.createElement("div");
        UIComponent facet = null;
        if (isFrist) {
            facet = panelDivider.getFirstFacet();
            clientId = clientId + "First";
            pane.setAttribute("id", ClientIdPool.get((String)clientId));
            pane.setAttribute("class", panelDivider.getFirstPaneClass());
        } else {
            facet = panelDivider.getSecondFacet();
            clientId = clientId + "Second";
            pane.setAttribute("id", ClientIdPool.get((String)clientId));
            pane.setAttribute("class", panelDivider.getSecondPaneClass());
        }
        pane.setAttribute("style", panelDivider.getPanePosition(isFrist));
        if (facet == null) {
            return;
        }
        Element container = (Element)domContext.getRootNode().getFirstChild();
        container.appendChild(pane);
        domContext.setCursorParent((Node)pane);
        CustomComponentUtils.renderChild(facesContext, facet);
    }

    private void addHiddenField(DOMContext domContext, Element root, String clientId, String name, String value) {
        Element hidden = domContext.createElement("input");
        String hiddenId = ClientIdPool.get((String)(clientId + name));
        hidden.setAttribute("id", hiddenId);
        hidden.setAttribute("name", hiddenId);
        if (value != null) {
            hidden.setAttribute("value", value);
        }
        hidden.setAttribute("type", "hidden");
        root.appendChild(hidden);
    }
}

