/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.nonAxisChart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.chartData.interfaces.IRadarChartDataSet;
import org.krysalis.jcharts.chartData.processors.RadarChartDataProcessor;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.RadarChartProperties;
import org.krysalis.jcharts.properties.util.ChartFont;

public class RadarChart
extends Chart {
    private IRadarChartDataSet iRadarChartDataSet;
    private RadarChartDataProcessor radarChartDataProcessor;
    private RadarChartProperties props;
    private double radius;
    private double step;
    private Point2D center;
    private double scaleMax;
    private double scaleIncrement;
    private static final int DEFAULT_NR_OF_INCREMENTS = 10;

    public RadarChart(IRadarChartDataSet iRadarChartDataSet, LegendProperties legendProperties, ChartProperties chartProperties, int n, int n2) {
        super(legendProperties, chartProperties, n, n2);
        this.iRadarChartDataSet = iRadarChartDataSet;
        this.props = (RadarChartProperties)iRadarChartDataSet.getChartTypeProperties();
        if (this.props == null) {
            this.props = new RadarChartProperties();
        }
    }

    protected void renderChart() {
        Graphics2D graphics2D = this.getGraphics2D();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontRenderContext fontRenderContext = super.getGraphics2D().getFontRenderContext();
        float f = super.renderChartTitle(this.iRadarChartDataSet.getChartTitle(), fontRenderContext);
        this.radarChartDataProcessor = new RadarChartDataProcessor(this.iRadarChartDataSet);
        this.radarChartDataProcessor.processData();
        this.scaleMax = Double.isNaN(this.props.getScaleMaxValue()) ? this.radarChartDataProcessor.getMaxValue() : this.props.getScaleMaxValue();
        this.scaleIncrement = Double.isNaN(this.props.getScaleIncrement()) ? this.scaleMax / 10.0 : this.props.getScaleIncrement();
        Rectangle rectangle = new Rectangle(this.getImageWidth(), this.getImageHeight());
        this.center = new Point2D.Double(rectangle.getWidth() / 2.0 - rectangle.getX(), rectangle.getHeight() / 2.0 - rectangle.getY());
        this.radius = Math.min(rectangle.getWidth(), rectangle.getHeight());
        this.radius = (this.radius - this.radius * 10.0 / 100.0) / 2.0;
        this.step = Math.PI * 2 / (double)this.iRadarChartDataSet.getNumberOfDataItems();
        if (this.props.getShowGridLines()) {
            this.drawGridLines(graphics2D);
        }
        this.drawAxis(graphics2D);
        this.drawRadar(graphics2D);
    }

    private void drawRadar(Graphics2D graphics2D) {
        for (int i = 0; i < this.iRadarChartDataSet.getNumberOfDataSets(); ++i) {
            double d = this.scaleValue(this.iRadarChartDataSet.getValue(i, this.iRadarChartDataSet.getNumberOfDataItems() - 1));
            Paint paint = this.iRadarChartDataSet.getPaint(i);
            for (int j = 0; j < this.iRadarChartDataSet.getNumberOfDataItems(); ++j) {
                double d2 = d;
                d = this.scaleValue(this.iRadarChartDataSet.getValue(i, j));
                graphics2D.setPaint(paint);
                int n = (int)Math.round(this.center.getX());
                int n2 = (int)Math.round(this.center.getY());
                int n3 = this.getX(j + 1, d);
                int n4 = this.getY(j + 1, d);
                int n5 = this.getX(j, d2);
                int n6 = this.getY(j, d2);
                if (this.props.getFillRadar()) {
                    Polygon polygon = new Polygon();
                    polygon.addPoint(n, n2);
                    polygon.addPoint(n3, n4);
                    polygon.addPoint(n5, n6);
                    if (paint instanceof Color) {
                        Color color = (Color)paint;
                        graphics2D.setPaint(new Color(color.getRed(), color.getGreen(), color.getBlue(), 100));
                    }
                    graphics2D.fillPolygon(polygon);
                    graphics2D.setPaint(paint);
                }
                graphics2D.drawLine(n3, n4, n5, n6);
            }
        }
    }

    private void drawGridLines(Graphics2D graphics2D) {
        graphics2D.setColor(Color.lightGray);
        for (int i = 0; i < this.iRadarChartDataSet.getNumberOfDataItems(); ++i) {
            for (double d = this.scaleIncrement; d <= this.scaleMax; d += this.scaleIncrement) {
                double d2 = this.scaleValue(d);
                graphics2D.drawLine(this.getX(i + 1, d2), this.getY(i + 1, d2), this.getX(i, d2), this.getY(i, d2));
            }
        }
    }

    private void drawAxis(Graphics2D graphics2D) {
        int n;
        graphics2D.setColor(Color.darkGray);
        for (n = 0; n < this.iRadarChartDataSet.getNumberOfDataItems(); ++n) {
            String string = this.iRadarChartDataSet.getAxisLabel(n);
            graphics2D.drawLine((int)this.center.getX(), (int)this.center.getY(), this.getX(n, 1.0), this.getY(n, 1.0));
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            ChartFont chartFont = this.props.getTitleChartFont();
            if (chartFont != null) {
                graphics2D.setFont(chartFont.getFont());
            }
            graphics2D.drawString(string, (int)((double)this.getX(n + 1, 1.0) - rectangle2D.getWidth() / 2.0), this.getY(n + 1, 1.0));
        }
        graphics2D.setColor(Color.darkGray);
        graphics2D.setFont(ChartFont.DEFAULT_AXIS_VALUE.getFont());
        n = this.iRadarChartDataSet.getNumberOfDataItems() / 2;
        for (double d = this.scaleIncrement; d <= this.scaleMax; d += this.scaleIncrement) {
            double d2 = this.scaleValue(d);
            Rectangle2D rectangle2D = graphics2D.getFont().getStringBounds("1", graphics2D.getFontRenderContext());
            graphics2D.drawString(this.props.getGridLabelFormat().format(d), this.getX(n, d2), (int)Math.round((double)this.getY(n, d2) + rectangle2D.getHeight()));
        }
    }

    private int getX(int n, double d) {
        return (int)Math.round(this.center.getX() + this.radius * d * Math.sin(this.step * (double)n));
    }

    private int getY(int n, double d) {
        return (int)Math.round(this.center.getY() + this.radius * d * Math.cos(this.step * (double)n));
    }

    private double scaleValue(double d) {
        if (d > this.scaleMax) {
            d = this.scaleMax;
        }
        if (this.scaleMax == 0.0) {
            return 0.0;
        }
        return d / this.scaleMax;
    }
}

