/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.lifecycle.PhaseExecutor;
import org.apache.myfaces.portlet.MyFacesGenericPortlet;
import org.apache.myfaces.portlet.PortletUtil;
import org.apache.myfaces.shared_impl.util.RestoreStateUtils;
import org.apache.myfaces.util.DebugUtils;

class RestoreViewExecutor
implements PhaseExecutor {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = RestoreViewExecutor.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl));
    static /* synthetic */ Class class$org$apache$myfaces$lifecycle$LifecycleImpl;

    RestoreViewExecutor() {
    }

    public boolean execute(FacesContext facesContext) {
        Application application;
        ViewHandler viewHandler;
        UIViewRoot viewRoot;
        if (facesContext.getViewRoot() != null) {
            facesContext.getViewRoot().setLocale(facesContext.getExternalContext().getRequestLocale());
            RestoreStateUtils.recursivelyHandleComponentReferencesAndSetValid(facesContext, (UIComponent)facesContext.getViewRoot());
            return false;
        }
        String viewId = RestoreViewExecutor.deriveViewId(facesContext);
        if (viewId == null) {
            ExternalContext externalContext = facesContext.getExternalContext();
            if (externalContext.getRequestServletPath() == null) {
                return true;
            }
            if (!externalContext.getRequestServletPath().endsWith("/")) {
                try {
                    externalContext.redirect(externalContext.getRequestServletPath() + "/");
                    facesContext.responseComplete();
                    return true;
                }
                catch (IOException e) {
                    throw new FacesException("redirect failed", (Throwable)e);
                }
            }
        }
        if ((viewRoot = (viewHandler = (application = facesContext.getApplication()).getViewHandler()).restoreView(facesContext, viewId)) == null) {
            viewRoot = viewHandler.createView(facesContext, viewId);
            viewRoot.setViewId(viewId);
            facesContext.renderResponse();
        }
        facesContext.setViewRoot(viewRoot);
        if (facesContext.getExternalContext().getRequestParameterMap().isEmpty()) {
            facesContext.renderResponse();
        }
        RestoreStateUtils.recursivelyHandleComponentReferencesAndSetValid(facesContext, (UIComponent)viewRoot);
        return false;
    }

    public PhaseId getPhase() {
        return PhaseId.RESTORE_VIEW;
    }

    private static String deriveViewId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        if (PortletUtil.isPortletRequest(facesContext)) {
            PortletRequest request = (PortletRequest)externalContext.getRequest();
            return request.getParameter(MyFacesGenericPortlet.VIEW_ID);
        }
        String viewId = externalContext.getRequestPathInfo();
        if (viewId == null) {
            viewId = externalContext.getRequestServletPath();
            DebugUtils.assertError(viewId != null, log, "RequestServletPath is null, cannot determine viewId of current page.");
            if (viewId == null) {
                return null;
            }
            String defaultSuffix = externalContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            String suffix = defaultSuffix != null ? defaultSuffix : ".jsp";
            DebugUtils.assertError(suffix.charAt(0) == '.', log, "Default suffix must start with a dot!");
            int dot = viewId.lastIndexOf(46);
            if (dot == -1) {
                log.error((Object)("Assumed extension mapping, but there is no extension in " + viewId));
                viewId = null;
            } else {
                viewId = viewId.substring(0, dot) + suffix;
            }
        }
        return viewId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

