/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.NoRowAvailableException;

public class ListDataModel
extends DataModel {
    private int index = -1;
    private List list;

    public ListDataModel() {
        this(null);
    }

    public ListDataModel(List list) {
        this.setWrappedData(list);
    }

    public boolean isRowAvailable() {
        if (this.list == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.list.size();
    }

    public int getRowCount() {
        if (this.list == null) {
            return -1;
        }
        return this.list.size();
    }

    public Object getRowData() {
        if (this.list == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new NoRowAvailableException();
        }
        return this.list.get(this.index);
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.list == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent(this, this.index, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    public Object getWrappedData() {
        return this.list;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.list = null;
            this.setRowIndex(-1);
        } else {
            this.list = (List)data;
            this.index = -1;
            this.setRowIndex(0);
        }
    }
}

