/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.context.DOMResponseWriter;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.ConfigurationException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMContext
implements Serializable {
    private transient DOMResponseWriter writer;
    private Node cursor;
    private Document document;
    private Node rootNode;
    private Node parentElement;
    private boolean initialized;

    protected DOMContext(DOMResponseWriter writer, Document document, Node parentElement) {
        this.writer = writer;
        this.document = document;
        this.cursor = parentElement;
        this.parentElement = parentElement;
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public static DOMContext attachDOMContext(FacesContext facesContext, UIComponent component) {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        DOMResponseWriter domWriter = responseWriter instanceof DOMResponseWriter ? (DOMResponseWriter)responseWriter : DOMContext.createTemporaryDOMResponseWriter(responseWriter, facesContext);
        Node cursorParent = domWriter.getCursorParent();
        Document doc = domWriter.getDocument();
        Map domContexts = domWriter.getDomContexts();
        DOMContext context = null;
        String clientId = component.getClientId(FacesContext.getCurrentInstance());
        if (clientId != null && domContexts.containsKey(clientId)) {
            context = (DOMContext)domContexts.get(clientId);
        }
        if (null == context) {
            context = new DOMContext(domWriter, doc, cursorParent);
            domContexts.put(clientId, context);
        }
        if (context.isInitialized()) {
            if (!(cursorParent instanceof Element)) {
                context.stepOver();
                return context;
            }
            context.attach((Element)cursorParent);
        }
        context.stepOver();
        return context;
    }

    public static DOMContext reattachDOMContext(FacesContext facesContext, UIComponent component) {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        DOMResponseWriter domWriter = responseWriter instanceof DOMResponseWriter ? (DOMResponseWriter)responseWriter : DOMContext.createTemporaryDOMResponseWriter(responseWriter, facesContext);
        Document doc = domWriter.getDocument();
        Map domContexts = domWriter.getDomContexts();
        DOMContext context = null;
        String clientId = component.getClientId(FacesContext.getCurrentInstance());
        if (domContexts.containsKey(clientId)) {
            context = (DOMContext)domContexts.get(clientId);
        }
        if (null == context) {
            Node cursorParent = domWriter.getCursorParent();
            context = new DOMContext(domWriter, doc, cursorParent);
            domContexts.put(clientId, context);
        } else {
            domWriter.setCursorParent(context.getRootNode());
        }
        return context;
    }

    private static DOMResponseWriter createTemporaryDOMResponseWriter(ResponseWriter responseWriter, FacesContext facesContext) {
        try {
            Method delegateMethod = responseWriter.getClass().getDeclaredMethod("getWrapped", new Class[0]);
            delegateMethod.setAccessible(true);
            Object delegate = delegateMethod.invoke((Object)responseWriter, (Object[])null);
            if (delegate instanceof DOMResponseWriter) {
                return (DOMResponseWriter)((Object)delegate);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        DOMResponseWriter domWriter = new DOMResponseWriter(facesContext, null, new Configuration(){

            public String getName() {
                return "noop configuration";
            }

            public Configuration getChild(String child) throws ConfigurationException {
                throw new ConfigurationException("child not available");
            }

            public Configuration[] getChildren(String name) throws ConfigurationException {
                throw new ConfigurationException("children not available");
            }

            public String getAttribute(String paramName) throws ConfigurationException {
                throw new ConfigurationException("attribute not available");
            }

            public String getValue() throws ConfigurationException {
                throw new ConfigurationException("value not available");
            }
        }, Collections.EMPTY_LIST, Collections.EMPTY_LIST, null);
        Document doc = domWriter.getDocument();
        Element html = doc.createElement("html");
        doc.appendChild(html);
        Element body = doc.createElement("body");
        html.appendChild(body);
        domWriter.setCursorParent(body);
        return domWriter;
    }

    public static DOMContext getDOMContext(FacesContext facesContext, UIComponent component) {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        DOMResponseWriter domWriter = responseWriter instanceof DOMResponseWriter ? (DOMResponseWriter)responseWriter : DOMContext.createTemporaryDOMResponseWriter(responseWriter, facesContext);
        Document doc = domWriter.getDocument();
        Map domContexts = domWriter.getDomContexts();
        DOMContext context = null;
        String clientId = component.getClientId(FacesContext.getCurrentInstance());
        if (domContexts.containsKey(clientId)) {
            context = (DOMContext)domContexts.get(clientId);
        }
        if (null == context) {
            Node cursorParent = domWriter.getCursorParent();
            context = new DOMContext(domWriter, doc, cursorParent);
            domContexts.put(clientId, context);
        }
        return context;
    }

    private void attach(Element cursorParent) {
        if (null == this.rootNode) {
            return;
        }
        if (this.rootNode.equals(cursorParent)) {
            return;
        }
        if (this.rootNode.getParentNode() != cursorParent) {
            try {
                cursorParent.appendChild(this.rootNode);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
    }

    public Element createElement(String name) {
        return this.document.createElement(name);
    }

    public Text createTextNode(String cData) {
        return this.document.createTextNode(cData);
    }

    public void setRootNode(Node rootNode) {
        this.rootNode = rootNode;
        this.parentElement.appendChild(rootNode);
        this.initialized = true;
    }

    public Element createRootElement(String name) {
        Element rootElement = this.createElement(name);
        this.setRootNode(rootElement);
        return rootElement;
    }

    void setIsolatedRootNode(Node rootElement) {
        this.rootNode = rootElement;
        this.initialized = true;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setCursorParent(Node cursorParent) {
        this.cursor = cursorParent;
        this.writer.setCursorParent(cursorParent);
    }

    public Node getCursorParent() {
        return this.cursor;
    }

    public void stepOver() {
        if (null != this.rootNode && this.rootNode.getParentNode() != null) {
            this.setCursorParent(this.rootNode.getParentNode());
        }
    }

    public void stepInto(UIComponent component) {
        if (this.rootNode != null) {
            this.setCursorParent(this.rootNode);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public static void removeChildren(Node parent) {
        while (parent.hasChildNodes()) {
            parent.removeChild(parent.getFirstChild());
        }
    }

    public static void removeChildrenByTagName(Element rootElement, String name) {
        Node nextChildToRemove = null;
        while (rootElement.hasChildNodes() && (nextChildToRemove = DOMContext.findChildWithNodeName(rootElement, name)) != null) {
            rootElement.removeChild(nextChildToRemove);
        }
    }

    private static Node findChildWithNodeName(Element root, String nodeName) {
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node nextChildNode = children.item(i);
            String name = nextChildNode.getNodeName();
            if (!name.equalsIgnoreCase(nodeName)) continue;
            return nextChildNode;
        }
        return null;
    }

    public static List findChildrenWithNodeName(Element root, String nodeName) {
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        ArrayList<Node> foundItems = new ArrayList<Node>();
        for (int i = 0; i < length; ++i) {
            Node nextChildNode = children.item(i);
            String name = nextChildNode.getNodeName();
            if (!name.equalsIgnoreCase(nodeName)) continue;
            foundItems.add(nextChildNode);
        }
        return foundItems;
    }
}

