/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.application;

import com.icesoft.faces.application.state.Util;
import com.icesoft.faces.context.BridgeFacesContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SingleCopyStateManagerImpl
extends StateManager {
    protected static Log log = LogFactory.getLog((Class)SingleCopyStateManagerImpl.class);
    protected Map classMap = new ConcurrentHashMap(32);
    protected boolean serialize_server_state;
    protected boolean compress_view_state;
    protected static final String SERIALIZE_SERVER_STATE = "com.sun.faces.serializeServerState";
    protected static final String COMPRESS_VIEW_STATE = "com.sun.faces.compressViewState";
    protected boolean parametersInitialized;
    protected StateManager delegate;
    protected boolean pureDelegation;
    protected Method v2DelegateSaveViewMethod;
    static /* synthetic */ Class class$com$icesoft$faces$application$ViewRootStateManagerImpl;

    public SingleCopyStateManagerImpl(StateManager delegate) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Constructing SingleCopyStateManagerImpl with delegate: " + delegate));
        }
        this.delegate = delegate;
    }

    private void initializeParameters(FacesContext context) {
        if (this.parametersInitialized) {
            return;
        }
        ExternalContext ec = context.getExternalContext();
        this.serialize_server_state = Boolean.getBoolean(ec.getInitParameter(SERIALIZE_SERVER_STATE));
        this.compress_view_state = Boolean.getBoolean(ec.getInitParameter(COMPRESS_VIEW_STATE));
        StackTraceElement[] ste = new RuntimeException().getStackTrace();
        boolean external = false;
        for (int i = 0; i < ste.length; ++i) {
            String className = ste[i].getClassName();
            if (className.equals((class$com$icesoft$faces$application$ViewRootStateManagerImpl == null ? SingleCopyStateManagerImpl.class$("com.icesoft.faces.application.ViewRootStateManagerImpl") : class$com$icesoft$faces$application$ViewRootStateManagerImpl).getName()) || className.equals(((Object)((Object)this)).getClass().getName())) {
                if (!external) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Pure delegate role taken by SingleCopyStateSavingImpl");
                }
                this.pureDelegation = true;
                break;
            }
            external = true;
        }
        try {
            this.v2DelegateSaveViewMethod = this.delegate.getClass().getMethod("saveView", FacesContext.class);
        }
        catch (Exception e) {
            log.error((Object)"Exception finding JSF1.2 saveView method on delegate", (Throwable)e);
        }
        this.parametersInitialized = true;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        Object[] stateArray;
        this.initializeParameters(context);
        if (this.pureDelegation || !(context instanceof BridgeFacesContext)) {
            return this.delegate.restoreView(context, viewId, renderKitId);
        }
        ExternalContext externalCtx = context.getExternalContext();
        HashMap viewMap = (HashMap)externalCtx.getSessionMap().get("icefaces.state.maps");
        if (viewMap == null) {
            Map sessionMap = externalCtx.getSessionMap();
            viewMap = new HashMap();
            sessionMap.put("icefaces.state.maps", viewMap);
        }
        BridgeFacesContext bfc = (BridgeFacesContext)context;
        String viewNumber = bfc.getViewNumber();
        if (log.isDebugEnabled()) {
            log.debug((Object)("RestoreView called for View: " + bfc.getIceFacesId() + ", viewNumber: " + viewNumber));
        }
        if ((stateArray = (Object[])viewMap.get(viewNumber)) == null) {
            log.error((Object)("Session Available, but View State does not exist for viewId:" + viewId));
            return null;
        }
        UIViewRoot viewRoot = Util.restoreTree((Object[])((Object[])stateArray[0]).clone(), this.classMap);
        viewRoot.processRestoreState(context, this.handleRestoreState(stateArray[1]));
        return viewRoot;
    }

    public Object saveView(FacesContext context) {
        StateManager sm;
        UIViewRoot viewRoot;
        if (this.pureDelegation || !(context instanceof BridgeFacesContext)) {
            if (this.v2DelegateSaveViewMethod != null) {
                try {
                    return this.v2DelegateSaveViewMethod.invoke((Object)this.delegate, context);
                }
                catch (Exception e) {
                    log.error((Object)"Exception in saveView", (Throwable)e);
                }
            } else {
                return this.delegate.saveSerializedView(context);
            }
        }
        if ((viewRoot = context.getViewRoot()).isTransient()) {
            return null;
        }
        this.checkIdUniqueness(context, (UIComponent)viewRoot, new HashSet(viewRoot.getChildCount() << 1));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Begin creating serialized view for " + viewRoot.getViewId()));
        }
        Object state = viewRoot.processSaveState(context);
        Util.CaptureArray tree = new Util.CaptureArray();
        Util.captureChildNode(tree, 0, (UIComponent)viewRoot);
        Object[] objTree = tree.toArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)("End creating serialized view " + viewRoot.getViewId()));
        }
        BridgeFacesContext bfc = (BridgeFacesContext)context;
        String viewNumber = bfc.getViewNumber();
        Map sessionMap = bfc.getExternalContext().getSessionMap();
        HashMap<String, Object[]> stateMap = (HashMap<String, Object[]>)sessionMap.get("icefaces.state.maps");
        if (stateMap == null) {
            stateMap = new HashMap<String, Object[]>();
            sessionMap.put("icefaces.state.maps", stateMap);
        }
        StateManager stateManager = sm = context.getApplication().getStateManager();
        stateManager.getClass();
        StateManager.SerializedView result = new StateManager.SerializedView(stateManager, (Object)viewNumber, null);
        stateMap.put(viewNumber, new Object[]{objTree, this.handleSaveState(state)});
        return result;
    }

    public StateManager.SerializedView saveSerializedView(FacesContext context) {
        this.initializeParameters(context);
        if (this.pureDelegation || !(context instanceof BridgeFacesContext)) {
            return this.delegate.saveSerializedView(context);
        }
        return (StateManager.SerializedView)this.saveView(context);
    }

    public void writeState(FacesContext context, StateManager.SerializedView view) throws IOException {
        this.delegate.writeState(context, view);
    }

    public static void writeRenderKitIdField(FacesContext context, ResponseWriter writer) throws IOException {
        String result = context.getApplication().getDefaultRenderKitId();
        if (result != null && !"HTML_BASIC".equals(result)) {
            writer.startElement("input", (UIComponent)context.getViewRoot());
            writer.writeAttribute("type", (Object)"hidden", "type");
            writer.writeAttribute("name", (Object)"javax.faces.RenderKitId", "name");
            writer.writeAttribute("value", (Object)result, "value");
            writer.endElement("input");
        }
    }

    protected void checkIdUniqueness(FacesContext context, UIComponent component, Set componentIds) throws IllegalStateException {
        Iterator i = component.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent kid = (UIComponent)i.next();
            String id = kid.getClientId(context);
            if (componentIds.add(id)) {
                this.checkIdUniqueness(context, kid, componentIds);
                continue;
            }
            String message = "duplicate component id error:" + id;
            if (log.isErrorEnabled()) {
                log.error((Object)message);
            }
            throw new IllegalStateException(message);
        }
    }

    private Object handleRestoreState(Object state) {
        if (this.serialize_server_state) {
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])state);
            ObjectInputStream ois = null;
            try {
                ois = this.compress_view_state ? new ObjectInputStream(new GZIPInputStream((InputStream)bais, 1024)) : new ObjectInputStream(bais);
                Object object = ois.readObject();
                return object;
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        return state;
    }

    private Object handleSaveState(Object state) {
        if (this.serialize_server_state) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oas = null;
            try {
                oas = this.compress_view_state ? new ObjectOutputStream(new GZIPOutputStream((OutputStream)baos, 1024)) : new ObjectOutputStream(baos);
                oas.writeObject(state);
                oas.flush();
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                if (oas != null) {
                    try {
                        oas.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return baos.toByteArray();
        }
        return state;
    }

    public void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        return null;
    }

    protected Object getComponentStateToSave(FacesContext context) {
        return null;
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        return null;
    }
}

