package de.dass_it.vanhelsing.gui;

import javax.faces.model.SelectItem;
import de.dass_it.vanhelsing.gui.items.ItemType;
import de.dass_it.vanhelsing.gui.items.UserObjectItem;
/**
 * The class ViewItem is used for the visualization of a SimpleResource object.
 * Rendered SimpleResources are ArrayLists of ViewItem objects.
 * @author tgoecke
 *
 */
public class ViewItem extends ItemType implements UserObjectItem {
	private String key;
	private String keyValue;
	private boolean required;
	private String renderer;
	private String dataType;
	private SelectItem[] keyValueList;

	private String inputText;
	private String selectOneMenu;
	private String radioGroup;
	public ViewItem(){
		inputText = null;
		selectOneMenu = null;
		radioGroup = null;
	}
	
	public boolean getRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}

	public String getRenderer() {
		return renderer;
	}

	public void setRenderer(String renderer) {
		this.renderer = renderer;
	}

	public String getDataType() {
		return dataType;
	}

	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	
	public int getResId(){
		return super.getResId();
	}
	public void setResId(int id){
		super.setResId(id);
	}
	public String getResType(){
		return super.getResType();
	}
	public void setResType(String resType){
		super.setResType(resType);
	}
	//eigene Felder für die Tabellenspalten
	public void setKey(String key) {
		this.key = key;
	}

	public String getKey() {
		return key;
	}
	
	public String getKeyValue() {
		return keyValue;
	}

	public void setKeyValue(String keyValue) {
		this.keyValue = keyValue;
	}

	public void setInputText(String inputText) {
		this.inputText = inputText;
	}

	public String getInputText() {
		return inputText;
	}

	public void setSelectOneMenu(String selectOneMenu) {
		this.selectOneMenu = selectOneMenu;
	}

	public String getSelectOneMenu() {
		return selectOneMenu;
	}
	/**
	 * Set the string property of the intended render type to the value of the none empty string "bernd"
	 * @param r valid inputs are inputText, selectOneMenu and radioGroup 
	 */
	public void setRendererFlag(String r){
		if (r.equals("inputText")) {
			this.inputText = new String("bernd");
		}
		if (r.equals("selectOneMenu")){
			this.selectOneMenu = new String("bernd"); //null;
		}
		if (r.equals("radioGroup")){
			this.radioGroup = new String("bernd");
		}
	}
	/**
	 * Key-Value-Pairs for the SelectOneMenu
	 * @return an array of key value pairs as an SelectItem object array
	 */
	public SelectItem[] getKeyValueList() {
		return keyValueList;
	}
	/**
	 * 
	 * @param keyValueList
	 */
	public void setKeyValueList(SelectItem[] keyValueList) {
		this.keyValueList = keyValueList;
	}
}
