/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.concurrent.SessionInformation;
import org.springframework.security.concurrent.SessionRegistry;
import org.springframework.security.ui.session.HttpSessionDestroyedEvent;
import org.springframework.util.Assert;

public class SessionRegistryImpl
implements SessionRegistry,
ApplicationListener {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$concurrent$SessionRegistryImpl == null ? (class$org$springframework$security$concurrent$SessionRegistryImpl = SessionRegistryImpl.class$("org.springframework.security.concurrent.SessionRegistryImpl")) : class$org$springframework$security$concurrent$SessionRegistryImpl));
    private Map principals = Collections.synchronizedMap(new HashMap());
    private Map sessionIds = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$springframework$security$concurrent$SessionRegistryImpl;

    public Object[] getAllPrincipals() {
        return this.principals.keySet().toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionInformation[] getAllSessions(Object principal, boolean includeExpiredSessions) {
        Set sessionsUsedByPrincipal = (Set)this.principals.get(principal);
        if (sessionsUsedByPrincipal == null) {
            return null;
        }
        ArrayList<SessionInformation> list = new ArrayList<SessionInformation>();
        Set set = sessionsUsedByPrincipal;
        synchronized (set) {
            Iterator iter = sessionsUsedByPrincipal.iterator();
            while (iter.hasNext()) {
                String sessionId = (String)iter.next();
                SessionInformation sessionInformation = this.getSessionInformation(sessionId);
                if (sessionInformation == null || !includeExpiredSessions && sessionInformation.isExpired()) continue;
                list.add(sessionInformation);
            }
        }
        return list.toArray(new SessionInformation[0]);
    }

    public SessionInformation getSessionInformation(String sessionId) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        return (SessionInformation)this.sessionIds.get(sessionId);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof HttpSessionDestroyedEvent) {
            String sessionId = ((HttpSession)event.getSource()).getId();
            this.removeSessionInformation(sessionId);
        }
    }

    public void refreshLastRequest(String sessionId) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        SessionInformation info = this.getSessionInformation(sessionId);
        if (info != null) {
            info.refreshLastRequest();
        }
    }

    public synchronized void registerNewSession(String sessionId, Object principal) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        Assert.notNull((Object)principal, (String)"Principal required as per interface contract");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering session " + sessionId + ", for principal " + principal));
        }
        if (this.getSessionInformation(sessionId) != null) {
            this.removeSessionInformation(sessionId);
        }
        this.sessionIds.put(sessionId, new SessionInformation(principal, sessionId, new Date()));
        Set<String> sessionsUsedByPrincipal = (Set<String>)this.principals.get(principal);
        if (sessionsUsedByPrincipal == null) {
            sessionsUsedByPrincipal = Collections.synchronizedSet(new HashSet(4));
            this.principals.put(principal, sessionsUsedByPrincipal);
        }
        sessionsUsedByPrincipal.add(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionInformation(String sessionId) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        SessionInformation info = this.getSessionInformation(sessionId);
        if (info == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing session " + sessionId + " from set of registered sessions"));
        }
        this.sessionIds.remove(sessionId);
        Set sessionsUsedByPrincipal = (Set)this.principals.get(info.getPrincipal());
        if (sessionsUsedByPrincipal == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing session " + sessionId + " from principal's set of registered sessions"));
        }
        Set set = sessionsUsedByPrincipal;
        synchronized (set) {
            sessionsUsedByPrincipal.remove(sessionId);
            if (sessionsUsedByPrincipal.size() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removing principal " + info.getPrincipal() + " from registry"));
                }
                this.principals.remove(info.getPrincipal());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

