/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.encoders;

import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.imageMap.ImageMapNotSupportedException;
import org.krysalis.jcharts.properties.PropertyException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGEncoder {
    private SVGEncoder() throws Exception {
        throw new Exception("No need to create an instance of this class!");
    }

    public static void encode(Chart chart, OutputStream outputStream) throws ChartDataException, PropertyException, IOException {
        if (chart.getImageMap() != null) {
            throw new ImageMapNotSupportedException("HTML client-side image maps are not supported by the SVG format.");
        }
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument(null, "svg", null);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
        chart.setGraphics2D((Graphics2D)sVGGraphics2D);
        chart.render();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        sVGGraphics2D.stream((Writer)outputStreamWriter, false);
        ((Writer)outputStreamWriter).flush();
        ((Writer)outputStreamWriter).close();
    }
}

