/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.test;

import java.awt.Paint;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.chartData.AxisChartDataSet;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.DataSeries;
import org.krysalis.jcharts.imageMap.ImageMap;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.ChartTypeProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.LabelAxisProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.test.ChartTestDriver;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.test.TestDataGenerator;
import org.krysalis.jcharts.types.ChartType;

abstract class AxisChartTestBase {
    public AxisChartTestBase() {
        System.out.println("Running: " + this.getClass().getName());
    }

    abstract DataSeries getDataSeries() throws ChartDataException;

    abstract boolean supportsImageMap();

    static void axisChartTest(String string, AxisChartTestBase axisChartTestBase) throws ChartDataException, PropertyException {
        int n = 10;
        HTMLGenerator hTMLGenerator = new HTMLGenerator("" + string + "Test.html");
        for (int i = 0; i < n; ++i) {
            ImageMap imageMap;
            LabelAxisProperties labelAxisProperties;
            DataAxisProperties dataAxisProperties;
            DataSeries dataSeries = axisChartTestBase.getDataSeries();
            boolean bl = true;
            boolean bl2 = true;
            AxisProperties axisProperties = new AxisProperties(bl);
            axisProperties.setXAxisLabelsAreVertical(TestDataGenerator.getRandomNumber(1.0) > 0.5);
            TestDataGenerator.randomizeAxisProperties(axisProperties);
            if (bl) {
                dataAxisProperties = (DataAxisProperties)axisProperties.getXAxisProperties();
                labelAxisProperties = (LabelAxisProperties)axisProperties.getYAxisProperties();
            } else {
                dataAxisProperties = (DataAxisProperties)axisProperties.getYAxisProperties();
                labelAxisProperties = (LabelAxisProperties)axisProperties.getXAxisProperties();
            }
            dataAxisProperties.setRoundToNearest(1);
            if (dataSeries.getNumberOfAxisLabels() == 0) {
                labelAxisProperties.setShowAxisLabels(false);
            } else {
                labelAxisProperties.setShowAxisLabels(TestDataGenerator.getRandomNumber(1.0) > 0.3);
            }
            int n2 = (int)TestDataGenerator.getRandomNumber(500.0, 1000.0);
            int n3 = (int)TestDataGenerator.getRandomNumber(300.0, 800.0);
            LegendProperties legendProperties = new LegendProperties();
            TestDataGenerator.randomizeLegend(legendProperties);
            ChartProperties chartProperties = new ChartProperties();
            AxisChart axisChart = new AxisChart(dataSeries, chartProperties, axisProperties, legendProperties, n2, n3);
            String string2 = "" + string + i + ".png";
            if (bl2 && axisChartTestBase.supportsImageMap()) {
                axisChart.renderWithImageMap();
                imageMap = axisChart.getImageMap();
            } else {
                imageMap = null;
            }
            try {
                ChartTestDriver.exportImage(axisChart, string2);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                System.out.println();
            }
            axisChart.toHTML(hTMLGenerator, string2, imageMap);
            hTMLGenerator.addLineBreak();
        }
        hTMLGenerator.saveFile();
    }

    final DataSeries createDataSeries(int n) {
        String[] stringArray = null;
        if (TestDataGenerator.getRandomNumber(1.0) > 0.3) {
            stringArray = TestDataGenerator.getRandomStrings(n, (int)TestDataGenerator.getRandomNumber(10.0), false);
        }
        String string = TestDataGenerator.getRandomString(15, true);
        String string2 = TestDataGenerator.getRandomString(15, true);
        return new DataSeries(stringArray, string, string2, "This is a test title that is so freaking long is is going to wrap around the image for sure. lfksjg;ljs; dflgkjdfgsdgdg dsgdsgsdfg dsfgsdfgsdfgs dfgdsfgd");
    }

    AxisChartDataSet createAxisChartDataSet(ChartType chartType, ChartTypeProperties chartTypeProperties, int n, int n2, int n3, int n4) throws ChartDataException {
        double[][] dArray = TestDataGenerator.getRandomNumbers(n, n2, n3, n4);
        String[] stringArray = TestDataGenerator.getRandomStrings(n, 10, false);
        Paint[] paintArray = TestDataGenerator.getRandomPaints(n);
        return new AxisChartDataSet(dArray, stringArray, paintArray, chartType, chartTypeProperties);
    }
}

