/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dispatchers;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.dispatchers.AbstractOperationDispatcher;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPMessageBodyBasedOperationDispatcher
extends AbstractOperationDispatcher {
    public static final String NAME = "SOAPMessageBodyBasedOperationDispatcher";
    private static final Log log = LogFactory.getLog(SOAPMessageBodyBasedOperationDispatcher.class);

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        AxisOperation axisOperation;
        String localPart = messageContext.getEnvelope().getSOAPBodyFirstElementLocalName();
        if (localPart == null) {
            return null;
        }
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)(messageContext.getLogIDString() + " Checking for Operation using SOAP message body's first child's local name : " + localPart));
        }
        if ((axisOperation = service.getOperation(new QName(localPart))) == null) {
            QName qName;
            OMNamespace ns = messageContext.getEnvelope().getSOAPBodyFirstElementNS();
            if (ns != null) {
                qName = new QName(ns.getNamespaceURI(), localPart);
                axisOperation = service.getOperationByMessageElementQName(qName);
            }
            if (axisOperation == null) {
                qName = new QName(localPart);
                axisOperation = service.getOperation(qName);
            }
        }
        return axisOperation;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

