/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.test;

import java.io.FileWriter;
import java.util.Iterator;
import org.krysalis.jcharts.imageMap.ImageMap;
import org.krysalis.jcharts.imageMap.ImageMapArea;

public final class HTMLGenerator {
    private String fileName;
    private StringBuffer stringBuffer;

    public HTMLGenerator(String string) {
        this.fileName = string;
        this.stringBuffer = new StringBuffer(1024);
        this.stringBuffer.append("<HTML><BODY>");
    }

    public void addField(String string, Object object) {
        if (object instanceof boolean[]) {
            this.addTableRow(string, HTMLGenerator.arrayToString((boolean[])object));
        } else if (object instanceof int[]) {
            this.addTableRow(string, HTMLGenerator.arrayToString((int[])object));
        } else if (object instanceof double[]) {
            this.addTableRow(string, HTMLGenerator.arrayToString((double[])object));
        } else if (object instanceof float[]) {
            this.addTableRow(string, HTMLGenerator.arrayToString((float[])object));
        } else if (object instanceof Object[]) {
            this.addTableRow(string, HTMLGenerator.arrayToString((Object[])object));
        } else {
            this.addTableRow(string, object);
        }
    }

    public void addString(Object object) {
        this.stringBuffer.append(object != null ? object.toString() : "NULL");
    }

    public void addString(String string, Object object) {
        this.addString("<B>");
        this.stringBuffer.append(string);
        this.addString("</B>");
        this.stringBuffer.append(object.toString());
    }

    public static String arrayToString(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i].toString());
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static String arrayToString(boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i = 0; i < blArray.length; ++i) {
            stringBuffer.append(new Boolean(blArray[i]).toString());
            if (i >= blArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static String arrayToString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(Double.toString(dArray[i]));
            if (i >= dArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static String arrayToString(double[][] dArray) {
        StringBuffer stringBuffer = new StringBuffer(400);
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(" { ");
            for (int j = 0; j < dArray[0].length; ++j) {
                stringBuffer.append(dArray[i][j]);
                if (j >= dArray[0].length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }<BR> ");
        }
        return stringBuffer.toString();
    }

    public static String arrayToString(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < fArray.length; ++i) {
            stringBuffer.append(Float.toString(fArray[i]));
            if (i >= fArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static String arrayToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(Integer.toString(nArray[i]));
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public void addImage(String string, ImageMap imageMap) {
        this.stringBuffer.append("<img src=\"");
        this.stringBuffer.append(string);
        this.stringBuffer.append("\"");
        if (imageMap != null) {
            this.stringBuffer.append(" useMap=\"#");
            this.stringBuffer.append(string);
            this.stringBuffer.append("\"");
        }
        this.stringBuffer.append(">");
        if (imageMap != null) {
            this.addImageMapData(imageMap, string);
        }
    }

    private void addImageMapData(ImageMap imageMap, String string) {
        this.stringBuffer.append("<map name=\"");
        this.stringBuffer.append(string);
        this.stringBuffer.append("\">");
        Iterator iterator = imageMap.getIterator();
        while (iterator.hasNext()) {
            ImageMapArea imageMapArea = (ImageMapArea)iterator.next();
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append("href=\"javascript:alert( 'value= ");
            stringBuffer.append(imageMapArea.getValue());
            stringBuffer.append(",  legend label= ");
            stringBuffer.append(imageMapArea.getLengendLabel());
            stringBuffer.append(", axis label= ");
            stringBuffer.append(imageMapArea.getXAxisLabel());
            stringBuffer.append("');\"");
            this.stringBuffer.append(imageMapArea.toHTML(stringBuffer.toString()));
        }
        this.stringBuffer.append("</map>");
    }

    public void addLineBreak() {
        this.stringBuffer.append("<BR>");
    }

    public void saveFile() {
        this.stringBuffer.append("</BODY></HTML>");
        try {
            FileWriter fileWriter = new FileWriter(this.fileName);
            fileWriter.write(this.stringBuffer.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void addTableRow(String string, Object object) {
        this.addString("<TR><TD NOWRAP BGCOLOR=#FFFFFF>");
        this.addString(string);
        this.addString("</TD><TD NOWRAP BGCOLOR=#FFFFFF>");
        this.addString(object);
        this.addString("</TD></TR>");
    }

    public void propertiesTableStart(String string) {
        this.addString("<TABLE BGCOLOR=#000000 BORDER=0 CELLSPACING=1 CELLPADDING=3>");
        this.addString("<TR><TD BGCOLOR=#D0FBCE COLSPAN=2><B>" + string + "</B></TD></TR>");
    }

    public void propertiesTableEnd() {
        this.addString("</TABLE>");
    }

    public void propertiesTableRowStart() {
        this.addString("<TR><TD WIDTH=100% BGCOLOR=#AAAAAA>");
    }

    public void propertiesTableRowEnd() {
        this.addString("</TD></TR>");
    }

    public void chartTableStart(String string, String string2, ImageMap imageMap) {
        this.addString("<TABLE BGCOLOR=#000000 BORDER=0 CELLSPACING=1 CELLPADDING=3>");
        this.addString("<TR><TD BGCOLOR=#FDFEC2 COLSPAN=1><B>" + string + "</B></TD></TR>");
        this.addString("<TR><TD WIDTH=100% BGCOLOR=#AAAAAA>");
        this.addImage(string2, imageMap);
        this.addString("</TD></TR>");
    }

    public void chartTableEnd() {
        this.addString("</TABLE>");
    }

    public void chartTableRowStart() {
        this.addString("<TR><TD WIDTH=100% BGCOLOR=#AAAAAA>");
    }

    public void chartTableRowEnd() {
        this.addString("</TD></TR>");
    }

    public void legendTableStart() {
        this.addString("<TABLE BGCOLOR=#000000 BORDER=0 CELLSPACING=1 CELLPADDING=3>");
        this.addString("<TR><TD BGCOLOR=#FDFEC2 COLSPAN=2><B>Legend</B></TD></TR>");
    }

    public void legendTableEnd() {
        this.addString("</TABLE>");
    }

    public void innerTableRowStart() {
        this.addString("<TR><TD WIDTH=100% COLSPAN=2 BGCOLOR=#777777>");
    }

    public void innerTableRowEnd() {
        this.addString("</TD></TR>");
    }
}

