/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.test;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.encoders.JPEGEncoder;
import org.krysalis.jcharts.encoders.JPEGEncoder13;
import org.krysalis.jcharts.encoders.PNGEncoder;
import org.krysalis.jcharts.encoders.SVGEncoder;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.test.AxisChartTestBase;
import org.krysalis.jcharts.test.BarTestDriver;
import org.krysalis.jcharts.test.StopWatch;

public final class ChartTestDriver {
    private static final String SVG = ".svg";
    private static final String PNG = ".png";
    private static final String JPEG = ".jpg";
    private static final String JPEG_LEGACY = ".jpeg";
    static final String OUTPUT_PATH = "";
    static final String EXTENSION = ".png";

    public static void main(String[] stringArray) throws ChartDataException, PropertyException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        AxisChartTestBase.axisChartTest("barChart", new BarTestDriver());
        stopWatch.stop();
        System.out.println(stopWatch);
    }

    private static void testAxisScale() {
        double d = -15.0;
        double d2 = -130.0;
        double d3 = Math.pow(10.0, Math.round(Math.log(d - d2) / Math.log(10.0)));
        double d4 = d2 - d2 % d3;
        double d5 = d - d % d3 + d3;
        System.out.println("yDelta= " + d3 + "   yStart= " + d4 + "   yEnd= " + d5);
        int n = (int)((d5 - d4) / d3);
        if (n <= 2) {
            d3 /= 10.0;
        } else if (n <= 5) {
            d3 /= 4.0;
        } else if (n <= 10) {
            d3 /= 2.0;
        }
        d4 = d2 - d2 % d3;
        d5 = d - d % d3 + d3;
        n = (int)((d5 - d4) / d3);
    }

    static void exportImage(Chart chart, String string) throws ChartDataException, PropertyException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            if (".png".equals(SVG)) {
                SVGEncoder.encode(chart, fileOutputStream);
            } else if (".png".equals(".png")) {
                PNGEncoder.encode(chart, fileOutputStream);
            } else if (".png".equals(JPEG)) {
                JPEGEncoder.encode(chart, 1.0f, fileOutputStream);
            } else if (".png".equals(JPEG_LEGACY)) {
                JPEGEncoder13.encode(chart, 1.0f, fileOutputStream);
            } else {
                System.out.println("unknown file type to encode: .png");
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

