/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl.basic.cache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.acl.basic.BasicAclEntryCache;
import org.acegisecurity.acl.basic.cache.BasicAclEntryHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.Assert;

public class EhCacheBasedAclEntryCache
implements BasicAclEntryCache,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$acl$basic$cache$EhCacheBasedAclEntryCache == null ? (class$org$acegisecurity$acl$basic$cache$EhCacheBasedAclEntryCache = EhCacheBasedAclEntryCache.class$("org.acegisecurity.acl.basic.cache.EhCacheBasedAclEntryCache")) : class$org$acegisecurity$acl$basic$cache$EhCacheBasedAclEntryCache));
    private Cache cache;
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$cache$EhCacheBasedAclEntryCache;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"cache mandatory");
    }

    public Cache getCache() {
        return this.cache;
    }

    public BasicAclEntry[] getEntriesFromCache(AclObjectIdentity aclObjectIdentity) {
        Element element = null;
        try {
            element = this.cache.get((Serializable)aclObjectIdentity);
        }
        catch (CacheException cacheException) {
            throw new DataRetrievalFailureException("Cache failure: " + cacheException.getMessage());
        }
        if (element == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache miss: " + aclObjectIdentity));
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache hit: " + (element != null) + "; object: " + aclObjectIdentity));
        }
        BasicAclEntryHolder holder = (BasicAclEntryHolder)element.getValue();
        return holder.getBasicAclEntries();
    }

    public void putEntriesInCache(BasicAclEntry[] basicAclEntry) {
        BasicAclEntryHolder holder = new BasicAclEntryHolder(basicAclEntry);
        Element element = new Element((Serializable)basicAclEntry[0].getAclObjectIdentity(), (Serializable)holder);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + element.getKey()));
        }
        this.cache.put(element);
    }

    public void removeEntriesFromCache(AclObjectIdentity aclObjectIdentity) {
        this.cache.remove((Serializable)aclObjectIdentity);
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

