/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.portlet;

import com.icesoft.faces.webapp.http.portlet.PortletArtifactWrapper;
import java.io.IOException;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainPortlet
extends GenericPortlet {
    private static Log log = LogFactory.getLog((Class)MainPortlet.class);
    public static final String PORTLET_MARKER = "portlet";
    protected PortletConfig portletConfig;

    public void init(PortletConfig portletConfig) throws PortletException {
        this.portletConfig = portletConfig;
        super.init(portletConfig);
    }

    protected void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        String viewId = this.getViewID("com.icesoft.faces.portlet.editPageURL", "com.icesoft.faces.EDIT");
        this.doInclude(renderRequest, renderResponse, viewId);
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        String viewId = this.getViewID("com.icesoft.faces.portlet.helpPageURL", "com.icesoft.faces.HELP");
        this.doInclude(renderRequest, renderResponse, viewId);
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        String viewId = this.getViewID("com.icesoft.faces.portlet.viewPageURL", "com.icesoft.faces.VIEW");
        this.doInclude(renderRequest, renderResponse, viewId);
    }

    protected String getViewID(String key, String oldKey) throws PortletException {
        String viewId = this.portletConfig.getInitParameter(key);
        if (viewId != null) {
            return viewId;
        }
        viewId = this.portletConfig.getInitParameter(oldKey);
        if (viewId != null) {
            return viewId;
        }
        String errorMessage = "cannot find view id for " + key + " or " + oldKey;
        if (log.isErrorEnabled()) {
            log.error((Object)errorMessage);
        }
        throw new PortletException(errorMessage);
    }

    protected void doInclude(RenderRequest renderRequest, RenderResponse renderResponse, String viewId) throws IOException, PortletException {
        MainPortlet.addAttribute(renderRequest, "com.icesoft.faces.NAMESPACE", renderResponse.getNamespace());
        MainPortlet.addAttribute(renderRequest, "com.icesoft.faces.PORTLET", PORTLET_MARKER);
        String flowKey = "org.springframework.webflow.FlowId";
        MainPortlet.addAttribute(renderRequest, flowKey, this.portletConfig.getInitParameter(flowKey));
        PortletContext ctxt = this.portletConfig.getPortletContext();
        PortletRequestDispatcher disp = ctxt.getRequestDispatcher(viewId);
        if (disp == null) {
            throw new PortletException("could not find dispatcher for " + viewId);
        }
        PortletArtifactWrapper wrapper = new PortletArtifactWrapper(this.portletConfig, renderRequest, renderResponse);
        MainPortlet.addAttribute(renderRequest, "com.icesoft.faces.portlet.artifact", wrapper);
        renderResponse.setContentType("text/html");
        disp.include(renderRequest, renderResponse);
    }

    private static void addAttribute(RenderRequest req, String key, Object value) {
        if (key != null && value != null) {
            req.setAttribute(key, value);
        }
    }
}

