/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttributeMap;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DOMNormalizer;
import org.apache.xerces.dom.DOMStringListImpl;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.DOMStringList;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XML11Char;
import org.apache.xerces.util.XMLChar;
import org.apache.xml.serialize.XML11Serializer;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public class DOMSerializerImpl
implements LSSerializer,
DOMConfiguration {
    private XMLSerializer serializer;
    private XML11Serializer xml11Serializer;
    private DOMStringList fRecognizedParameters;
    protected short features = 0;
    protected static final short NAMESPACES = 1;
    protected static final short WELLFORMED = 2;
    protected static final short ENTITIES = 4;
    protected static final short CDATA = 8;
    protected static final short SPLITCDATA = 16;
    protected static final short COMMENTS = 32;
    protected static final short DISCARDDEFAULT = 64;
    protected static final short INFOSET = 128;
    protected static final short XMLDECL = 256;
    protected static final short NSDECL = 512;
    protected static final short DOM_ELEMENT_CONTENT_WHITESPACE = 1024;
    private DOMErrorHandler fErrorHandler = null;
    private final DOMErrorImpl fError = new DOMErrorImpl();
    private final DOMLocatorImpl fLocator = new DOMLocatorImpl();
    private static final RuntimeException abort = new RuntimeException();

    public DOMSerializerImpl() {
        this.features = (short)(this.features | 1);
        this.features = (short)(this.features | 4);
        this.features = (short)(this.features | 0x20);
        this.features = (short)(this.features | 8);
        this.features = (short)(this.features | 0x10);
        this.features = (short)(this.features | 2);
        this.features = (short)(this.features | 0x200);
        this.features = (short)(this.features | 0x400);
        this.features = (short)(this.features | 0x40);
        this.features = (short)(this.features | 0x100);
        this.serializer = new XMLSerializer();
        this.initSerializer(this.serializer);
    }

    public DOMConfiguration getDomConfig() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setParameter(String string, Object object) throws DOMException {
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            if (string.equals("infoset")) {
                if (!bl) return;
                this.features = (short)(this.features & 0xFFFFFFFB);
                this.features = (short)(this.features & 0xFFFFFFF7);
                this.features = (short)(this.features | 1);
                this.features = (short)(this.features | 2);
                this.features = (short)(this.features | 0x20);
                return;
            }
            if (string.equals("xml-declaration")) {
                this.features = bl ? (short)(this.features | 0x100) : (short)(this.features & 0xFFFFFEFF);
                return;
            }
            if (string.equals("namespaces")) {
                this.features = bl ? (short)(this.features | 1) : (short)(this.features & 0xFFFFFFFE);
                this.serializer.fNamespaces = bl;
                return;
            }
            if (string.equals("split-cdata-sections")) {
                this.features = bl ? (short)(this.features | 0x10) : (short)(this.features & 0xFFFFFFEF);
                return;
            }
            if (string.equals("discard-default-content")) {
                this.features = bl ? (short)(this.features | 0x40) : (short)(this.features & 0xFFFFFFBF);
                return;
            }
            if (string.equals("well-formed")) {
                this.features = bl ? (short)(this.features | 2) : (short)(this.features & 0xFFFFFFFD);
                return;
            }
            if (string.equals("entities")) {
                this.features = bl ? (short)(this.features | 4) : (short)(this.features & 0xFFFFFFFB);
                return;
            }
            if (string.equals("cdata-sections")) {
                this.features = bl ? (short)(this.features | 8) : (short)(this.features & 0xFFFFFFF7);
                return;
            }
            if (string.equals("comments")) {
                this.features = bl ? (short)(this.features | 0x20) : (short)(this.features & 0xFFFFFFDF);
                return;
            }
            if (string.equals("canonical-form") || string.equals("validate-if-schema") || string.equals("validate") || string.equals("check-character-normalization") || string.equals("datatype-normalization") || string.equals("format-pretty-print") || string.equals("normalize-characters")) {
                if (!bl) return;
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                throw new DOMException(9, string2);
            }
            if (!(string.equals("namespace-declarations") || string.equals("element-content-whitespace") || string.equals("ignore-unknown-character-denormalizations"))) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
                throw new DOMException(9, string3);
            }
            if (bl) return;
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string4);
        }
        if (string.equals("error-handler")) {
            if (object != null && !(object instanceof DOMErrorHandler)) {
                String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{string});
                throw new DOMException(8, string5);
            }
            this.fErrorHandler = (DOMErrorHandler)object;
            return;
        }
        if (string.equals("resource-resolver") || string.equals("schema-location") || string.equals("schema-type") && object != null) {
            String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string6);
        }
        String string7 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
        throw new DOMException(8, string7);
    }

    public boolean canSetParameter(String string, Object object) {
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            if (string.equals("namespaces") || string.equals("split-cdata-sections") || string.equals("discard-default-content") || string.equals("xml-declaration") || string.equals("well-formed") || string.equals("infoset") || string.equals("entities") || string.equals("cdata-sections") || string.equals("comments")) {
                return true;
            }
            if (string.equals("canonical-form") || string.equals("validate-if-schema") || string.equals("validate") || string.equals("check-character-normalization") || string.equals("datatype-normalization") || string.equals("format-pretty-print") || string.equals("normalize-characters")) {
                return !bl;
            }
            if (string.equals("namespace-declarations") || string.equals("element-content-whitespace") || string.equals("ignore-unknown-character-denormalizations")) {
                return bl;
            }
        } else if (string.equals("error-handler") && object == null || object instanceof DOMErrorHandler) {
            return true;
        }
        return false;
    }

    public DOMStringList getParameterNames() {
        if (this.fRecognizedParameters == null) {
            Vector<String> vector = new Vector<String>();
            vector.add("namespaces");
            vector.add("split-cdata-sections");
            vector.add("discard-default-content");
            vector.add("xml-declaration");
            vector.add("canonical-form");
            vector.add("validate-if-schema");
            vector.add("validate");
            vector.add("check-character-normalization");
            vector.add("datatype-normalization");
            vector.add("format-pretty-print");
            vector.add("normalize-characters");
            vector.add("well-formed");
            vector.add("infoset");
            vector.add("namespace-declarations");
            vector.add("element-content-whitespace");
            vector.add("entities");
            vector.add("cdata-sections");
            vector.add("comments");
            vector.add("ignore-unknown-character-denormalizations");
            vector.add("error-handler");
            this.fRecognizedParameters = new DOMStringListImpl(vector);
        }
        return this.fRecognizedParameters;
    }

    public Object getParameter(String string) throws DOMException {
        if (string.equals("comments")) {
            return (this.features & 0x20) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("namespaces")) {
            return (this.features & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("xml-declaration")) {
            return (this.features & 0x100) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("cdata-sections")) {
            return (this.features & 8) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("entities")) {
            return (this.features & 4) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("split-cdata-sections")) {
            return (this.features & 0x10) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("well-formed")) {
            return (this.features & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("element-content-whitespace") || string.equals("ignore-unknown-character-denormalizations") || string.equals("namespace-declarations")) {
            return Boolean.TRUE;
        }
        if (string.equals("discard-default-content")) {
            return (this.features & 0x40) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("infoset")) {
            if ((this.features & 4) == 0 && (this.features & 8) == 0 && (this.features & 1) != 0 && (this.features & 2) != 0 && (this.features & 0x20) != 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (string.equals("format-pretty-print") || string.equals("normalize-characters") || string.equals("canonical-form") || string.equals("validate-if-schema") || string.equals("check-character-normalization") || string.equals("validate") || string.equals("validate-if-schema") || string.equals("datatype-normalization")) {
            return Boolean.FALSE;
        }
        if (string.equals("error-handler")) {
            return this.fErrorHandler;
        }
        if (string.equals("resource-resolver") || string.equals("schema-location") || string.equals("schema-type")) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string2);
        }
        String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
        throw new DOMException(8, string3);
    }

    public String writeToString(Node node) throws DOMException, LSException {
        StringWriter stringWriter;
        block14: {
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            Method method = null;
            XMLSerializer xMLSerializer = null;
            String string = null;
            try {
                method = document.getClass().getMethod("getXmlVersion", new Class[0]);
                if (method != null) {
                    string = (String)method.invoke((Object)document, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null && string.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                xMLSerializer = this.xml11Serializer;
            } else {
                xMLSerializer = this.serializer;
            }
            stringWriter = new StringWriter();
            try {
                this.prepareForSerialization(xMLSerializer, node);
                xMLSerializer.setOutputCharStream(stringWriter);
                if (node == null) {
                    return null;
                }
                if (node.getNodeType() == 9) {
                    xMLSerializer.serialize((Document)node);
                    break block14;
                }
                if (node.getNodeType() == 11) {
                    xMLSerializer.serialize((DocumentFragment)node);
                    break block14;
                }
                if (node.getNodeType() == 1) {
                    xMLSerializer.serialize((Element)node);
                    break block14;
                }
                return null;
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException == DOMNormalizer.abort) {
                    return null;
                }
                throw new LSException(82, runtimeException.toString());
            }
            catch (IOException iOException) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "STRING_TOO_LONG", new Object[]{iOException.getMessage()});
                throw new DOMException(2, string2);
            }
        }
        return stringWriter.toString();
    }

    public void setNewLine(String string) {
        this.serializer._format.setLineSeparator(string);
    }

    public String getNewLine() {
        return this.serializer._format.getLineSeparator();
    }

    public LSSerializerFilter getFilter() {
        return this.serializer.fDOMFilter;
    }

    public void setFilter(LSSerializerFilter lSSerializerFilter) {
        this.serializer.fDOMFilter = lSSerializerFilter;
    }

    private void initSerializer(XMLSerializer xMLSerializer) {
        xMLSerializer.fNSBinder = new NamespaceSupport();
        xMLSerializer.fLocalNSBinder = new NamespaceSupport();
        xMLSerializer.fSymbolTable = new SymbolTable();
    }

    private void copySettings(XMLSerializer xMLSerializer, XMLSerializer xMLSerializer2) {
        xMLSerializer2.fDOMErrorHandler = this.fErrorHandler;
        xMLSerializer2._format.setEncoding(xMLSerializer._format.getEncoding());
        xMLSerializer2._format.setLineSeparator(xMLSerializer._format.getLineSeparator());
        xMLSerializer2.fDOMFilter = xMLSerializer.fDOMFilter;
    }

    public boolean write(Node node, LSOutput lSOutput) throws LSException {
        block35: {
            Object object;
            if (node == null) {
                return false;
            }
            Method method = null;
            XMLSerializer xMLSerializer = null;
            String string = null;
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            try {
                method = document.getClass().getMethod("getXmlVersion", new Class[0]);
                if (method != null) {
                    string = (String)method.invoke((Object)document, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null && string.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                xMLSerializer = this.xml11Serializer;
            } else {
                xMLSerializer = this.serializer;
            }
            String string2 = null;
            string2 = lSOutput.getEncoding();
            if (string2 == null) {
                try {
                    object = document.getClass().getMethod("getActualEncoding", new Class[0]);
                    if (object != null) {
                        string2 = (String)((Method)object).invoke((Object)document, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string2 == null) {
                    try {
                        object = document.getClass().getMethod("getXmlEncoding", new Class[0]);
                        if (object != null) {
                            string2 = (String)((Method)object).invoke((Object)document, null);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string2 == null) {
                        string2 = "UTF-8";
                    }
                }
            }
            try {
                this.prepareForSerialization(xMLSerializer, node);
                xMLSerializer._format.setEncoding(string2);
                object = lSOutput.getByteStream();
                Writer writer = lSOutput.getCharacterStream();
                String string3 = lSOutput.getSystemId();
                if (writer == null) {
                    if (object == null) {
                        if (string3 == null) {
                            if (xMLSerializer.fDOMErrorHandler != null) {
                                DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                                dOMErrorImpl.fType = "no-output-specified";
                                dOMErrorImpl.fMessage = "no-output-specified";
                                dOMErrorImpl.fSeverity = (short)3;
                                xMLSerializer.fDOMErrorHandler.handleError(dOMErrorImpl);
                            }
                            throw new LSException(82, DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "no-output-specified", null));
                        }
                        String string4 = XMLEntityManager.expandSystemId(string3, null, true);
                        URL uRL = new URL(string4 != null ? string4 : string3);
                        OutputStream outputStream = null;
                        String string5 = uRL.getProtocol();
                        String string6 = uRL.getHost();
                        if (string5.equals("file") && (string6 == null || string6.length() == 0 || string6.equals("localhost"))) {
                            outputStream = new FileOutputStream(new File(uRL.getPath()));
                        } else {
                            URLConnection uRLConnection = uRL.openConnection();
                            uRLConnection.setDoInput(false);
                            uRLConnection.setDoOutput(true);
                            uRLConnection.setUseCaches(false);
                            if (uRLConnection instanceof HttpURLConnection) {
                                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                                httpURLConnection.setRequestMethod("PUT");
                            }
                            outputStream = uRLConnection.getOutputStream();
                        }
                        xMLSerializer.setOutputByteStream(outputStream);
                    } else {
                        xMLSerializer.setOutputByteStream((OutputStream)object);
                    }
                } else {
                    xMLSerializer.setOutputCharStream(writer);
                }
                if (node.getNodeType() == 9) {
                    xMLSerializer.serialize((Document)node);
                    break block35;
                }
                if (node.getNodeType() == 11) {
                    xMLSerializer.serialize((DocumentFragment)node);
                    break block35;
                }
                if (node.getNodeType() == 1) {
                    xMLSerializer.serialize((Element)node);
                    break block35;
                }
                return false;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (xMLSerializer.fDOMErrorHandler != null) {
                    DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                    dOMErrorImpl.fException = unsupportedEncodingException;
                    dOMErrorImpl.fType = "unsupported-encoding";
                    dOMErrorImpl.fMessage = unsupportedEncodingException.getMessage();
                    dOMErrorImpl.fSeverity = (short)3;
                    xMLSerializer.fDOMErrorHandler.handleError(dOMErrorImpl);
                }
                throw new LSException(82, DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "unsupported-encoding", null));
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException == DOMNormalizer.abort) {
                    return false;
                }
                throw new LSException(82, runtimeException.toString());
            }
            catch (Exception exception) {
                if (xMLSerializer.fDOMErrorHandler != null) {
                    DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                    dOMErrorImpl.fException = exception;
                    dOMErrorImpl.fMessage = exception.getMessage();
                    dOMErrorImpl.fSeverity = (short)2;
                    xMLSerializer.fDOMErrorHandler.handleError(dOMErrorImpl);
                }
                exception.printStackTrace();
                throw new LSException(82, exception.toString());
            }
        }
        return true;
    }

    public boolean writeToURI(Node node, String string) throws LSException {
        block26: {
            Object object;
            if (node == null) {
                return false;
            }
            Method method = null;
            XMLSerializer xMLSerializer = null;
            String string2 = null;
            String string3 = null;
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            try {
                method = document.getClass().getMethod("getXmlVersion", new Class[0]);
                if (method != null) {
                    string2 = (String)method.invoke((Object)document, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 != null && string2.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                xMLSerializer = this.xml11Serializer;
            } else {
                xMLSerializer = this.serializer;
            }
            try {
                object = document.getClass().getMethod("getActualEncoding", new Class[0]);
                if (object != null) {
                    string3 = (String)((Method)object).invoke((Object)document, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string3 == null) {
                try {
                    object = document.getClass().getMethod("getXmlEncoding", new Class[0]);
                    if (object != null) {
                        string3 = (String)((Method)object).invoke((Object)document, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string3 == null) {
                    string3 = "UTF-8";
                }
            }
            try {
                this.prepareForSerialization(xMLSerializer, node);
                xMLSerializer._format.setEncoding(string3);
                object = XMLEntityManager.expandSystemId(string, null, true);
                URL uRL = new URL((String)(object != null ? object : string));
                OutputStream outputStream = null;
                String string4 = uRL.getProtocol();
                String string5 = uRL.getHost();
                if (string4.equals("file") && (string5 == null || string5.length() == 0 || string5.equals("localhost"))) {
                    outputStream = new FileOutputStream(new File(uRL.getPath()));
                } else {
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setDoInput(false);
                    uRLConnection.setDoOutput(true);
                    uRLConnection.setUseCaches(false);
                    if (uRLConnection instanceof HttpURLConnection) {
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                        httpURLConnection.setRequestMethod("PUT");
                    }
                    outputStream = uRLConnection.getOutputStream();
                }
                xMLSerializer.setOutputByteStream(outputStream);
                if (node.getNodeType() == 9) {
                    xMLSerializer.serialize((Document)node);
                    break block26;
                }
                if (node.getNodeType() == 11) {
                    xMLSerializer.serialize((DocumentFragment)node);
                    break block26;
                }
                if (node.getNodeType() == 1) {
                    xMLSerializer.serialize((Element)node);
                    break block26;
                }
                return false;
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException == DOMNormalizer.abort) {
                    return false;
                }
                throw new LSException(82, runtimeException.toString());
            }
            catch (Exception exception) {
                if (xMLSerializer.fDOMErrorHandler != null) {
                    DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                    dOMErrorImpl.fException = exception;
                    dOMErrorImpl.fMessage = exception.getMessage();
                    dOMErrorImpl.fSeverity = (short)2;
                    xMLSerializer.fDOMErrorHandler.handleError(dOMErrorImpl);
                }
                throw new LSException(82, exception.toString());
            }
        }
        return true;
    }

    private void prepareForSerialization(XMLSerializer xMLSerializer, Node node) {
        xMLSerializer.reset();
        xMLSerializer.features = this.features;
        xMLSerializer.fDOMErrorHandler = this.fErrorHandler;
        xMLSerializer.fNamespaces = (this.features & 1) != 0;
        xMLSerializer._format.setOmitComments((this.features & 0x20) == 0);
        xMLSerializer._format.setOmitXMLDeclaration((this.features & 0x100) == 0);
        if ((this.features & 2) != 0) {
            Node node2 = node;
            boolean bl = true;
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            try {
                Method method = document.getClass().getMethod("isXMLVersionChanged()", new Class[0]);
                if (method != null) {
                    bl = (Boolean)method.invoke((Object)document, null);
                }
            }
            catch (Exception exception) {}
            while (node != null) {
                this.verify(node, bl, false);
                Node node3 = node.getFirstChild();
                while (node3 == null) {
                    node3 = node.getNextSibling();
                    if (node3 != null) continue;
                    if (node2 == (node = node.getParentNode())) {
                        node3 = null;
                        break;
                    }
                    node3 = node.getNextSibling();
                }
                node = node3;
            }
        }
    }

    private void verify(Node node, boolean bl, boolean bl2) {
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 1: {
                Object object;
                boolean bl3;
                if (bl && !(bl3 = (this.features & 1) != 0 ? CoreDocumentImpl.isValidQName(node.getPrefix(), node.getLocalName(), bl2) : CoreDocumentImpl.isXMLName(node.getNodeName(), bl2)) && !bl3 && this.fErrorHandler != null) {
                    object = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, (String)object, (short)3, null, "wf-invalid-character-in-node-name");
                }
                Object object2 = object = node.hasAttributes() ? (AttributeMap)node.getAttributes() : null;
                if (object == null) break;
                int n = 0;
                while (n < ((NamedNodeMapImpl)object).getLength()) {
                    Attr attr = (Attr)((NamedNodeMapImpl)object).item(n);
                    DOMNormalizer.isAttrValueWF(this.fErrorHandler, this.fError, this.fLocator, (AttributeMap)object, (AttrImpl)attr, attr.getValue(), bl2);
                    if (bl && !(bl3 = CoreDocumentImpl.isXMLName(node.getNodeName(), bl2))) {
                        String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Attr", node.getNodeName()});
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string, (short)3, null, "wf-invalid-character-in-node-name");
                    }
                    ++n;
                }
                break;
            }
            case 8: {
                if ((this.features & 0x20) == 0) break;
                DOMNormalizer.isCommentWF(this.fErrorHandler, this.fError, this.fLocator, ((Comment)node).getData(), bl2);
                break;
            }
            case 5: {
                if (!bl || (this.features & 4) == 0) break;
                CoreDocumentImpl.isXMLName(node.getNodeName(), bl2);
                break;
            }
            case 4: {
                DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), bl2);
                break;
            }
            case 3: {
                DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), bl2);
                break;
            }
            case 7: {
                boolean bl4;
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                String string = processingInstruction.getTarget();
                if (bl && !(bl4 = bl2 ? XML11Char.isXML11ValidName(string) : XMLChar.isValidName(string))) {
                    String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string2, (short)3, null, "wf-invalid-character-in-node-name");
                }
                DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, processingInstruction.getData(), bl2);
            }
        }
    }
}

