/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ldap;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapCallback;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.ldap.LdapEntryMapper;
import org.acegisecurity.ldap.LdapUtils;
import org.acegisecurity.ldap.NamingExceptionTranslator;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LdapTemplate {
    public static final String[] NO_ATTRS = new String[0];
    private InitialDirContextFactory dirContextFactory;
    private NamingExceptionTranslator exceptionTranslator = new LdapExceptionTranslator();
    private SearchControls searchControls = new SearchControls();
    private String password = null;
    private String principalDn = null;

    public LdapTemplate(InitialDirContextFactory dirContextFactory) {
        Assert.notNull((Object)dirContextFactory, (String)"An InitialDirContextFactory is required");
        this.dirContextFactory = dirContextFactory;
        this.searchControls.setSearchScope(2);
    }

    public LdapTemplate(InitialDirContextFactory dirContextFactory, String userDn, String password) {
        this(dirContextFactory);
        Assert.hasLength((String)userDn, (String)"userDn must not be null or empty");
        Assert.notNull((Object)password, (String)"password cannot be null");
        this.principalDn = userDn;
        this.password = password;
    }

    public boolean compare(String dn, String attributeName, Object value) {
        String comparisonFilter = "(" + attributeName + "={0})";
        class LdapCompareCallback
        implements LdapCallback {
            private final /* synthetic */ String val$dn;
            private final /* synthetic */ String val$comparisonFilter;
            private final /* synthetic */ Object val$value;

            LdapCompareCallback(String string, String string2, Object object) {
                this.val$dn = string;
                this.val$comparisonFilter = string2;
                this.val$value = object;
            }

            public Object doInDirContext(DirContext ctx) throws NamingException {
                SearchControls ctls = new SearchControls();
                ctls.setReturningAttributes(NO_ATTRS);
                ctls.setSearchScope(0);
                String relativeName = LdapUtils.getRelativeName(this.val$dn, ctx);
                NamingEnumeration<SearchResult> results = ctx.search(relativeName, this.val$comparisonFilter, new Object[]{this.val$value}, ctls);
                return results.hasMore();
            }
        }
        Boolean matches = (Boolean)this.execute(new LdapCompareCallback(dn, comparisonFilter, value));
        return matches;
    }

    public Object execute(LdapCallback callback) throws DataAccessException {
        Object object;
        DirContext ctx = null;
        try {
            ctx = this.principalDn == null ? this.dirContextFactory.newInitialDirContext() : this.dirContextFactory.newInitialDirContext(this.principalDn, this.password);
            object = callback.doInDirContext(ctx);
        }
        catch (NamingException exception) {
            try {
                throw this.exceptionTranslator.translate("LdapCallback", exception);
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(ctx);
                throw throwable;
            }
        }
        LdapUtils.closeContext(ctx);
        return object;
    }

    public boolean nameExists(final String dn) {
        Boolean exists = (Boolean)this.execute(new LdapCallback(){

            public Object doInDirContext(DirContext ctx) throws NamingException {
                try {
                    ctx.lookup(LdapUtils.getRelativeName(dn, ctx));
                }
                catch (NameNotFoundException nnfe) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return exists;
    }

    public Object retrieveEntry(final String dn, final LdapEntryMapper mapper, final String[] attributesToRetrieve) {
        return this.execute(new LdapCallback(){

            public Object doInDirContext(DirContext ctx) throws NamingException {
                return mapper.mapAttributes(dn, ctx.getAttributes(LdapUtils.getRelativeName(dn, ctx), attributesToRetrieve));
            }
        });
    }

    public Set searchForSingleAttributeValues(String base, String filter, Object[] params, String attributeName) {
        class SingleAttributeSearchCallback
        implements LdapCallback {
            private final /* synthetic */ String val$attributeName;
            private final /* synthetic */ String val$base;
            private final /* synthetic */ String val$filter;
            private final /* synthetic */ Object[] val$params;

            SingleAttributeSearchCallback(String string, String string2, String string3, Object[] objectArray) {
                this.val$attributeName = string;
                this.val$base = string2;
                this.val$filter = string3;
                this.val$params = objectArray;
            }

            public Object doInDirContext(DirContext ctx) throws NamingException {
                HashSet<String> unionOfValues = new HashSet<String>();
                SearchControls ctls = new SearchControls();
                ctls.setSearchScope(LdapTemplate.this.searchControls.getSearchScope());
                ctls.setTimeLimit(LdapTemplate.this.searchControls.getTimeLimit());
                ctls.setDerefLinkFlag(LdapTemplate.this.searchControls.getDerefLinkFlag());
                ctls.setReturningAttributes(new String[]{this.val$attributeName});
                NamingEnumeration<SearchResult> matchingEntries = ctx.search(this.val$base, this.val$filter, this.val$params, ctls);
                while (matchingEntries.hasMore()) {
                    SearchResult result = matchingEntries.next();
                    Attributes attrs = result.getAttributes();
                    NamingEnumeration<? extends Attribute> returnedAttributes = attrs.getAll();
                    while (returnedAttributes.hasMore()) {
                        Attribute returnedAttribute = returnedAttributes.next();
                        NamingEnumeration<?> attributeValues = returnedAttribute.getAll();
                        while (attributeValues.hasMore()) {
                            Object value = attributeValues.next();
                            unionOfValues.add(value.toString());
                        }
                    }
                }
                return unionOfValues;
            }
        }
        return (Set)this.execute(new SingleAttributeSearchCallback(attributeName, base, filter, params));
    }

    public Object searchForSingleEntry(final String base, final String filter, final Object[] params, final LdapEntryMapper mapper) {
        return this.execute(new LdapCallback(){

            public Object doInDirContext(DirContext ctx) throws NamingException {
                String nameInNamespace;
                NamingEnumeration<SearchResult> results = ctx.search(base, filter, params, LdapTemplate.this.searchControls);
                if (!results.hasMore()) {
                    throw new IncorrectResultSizeDataAccessException(1, 0);
                }
                SearchResult searchResult = results.next();
                if (results.hasMore()) {
                    throw new IncorrectResultSizeDataAccessException(1, 2);
                }
                StringBuffer dn = new StringBuffer(searchResult.getName());
                if (base.length() > 0) {
                    dn.append(",");
                    dn.append(base);
                }
                if (StringUtils.hasLength((String)(nameInNamespace = ctx.getNameInNamespace()))) {
                    dn.append(",");
                    dn.append(nameInNamespace);
                }
                return mapper.mapAttributes(dn.toString(), searchResult.getAttributes());
            }
        });
    }

    public void setSearchControls(SearchControls searchControls) {
        this.searchControls = searchControls;
    }

    private static class LdapExceptionTranslator
    implements NamingExceptionTranslator {
        private LdapExceptionTranslator() {
        }

        public DataAccessException translate(String task, NamingException e) {
            return new LdapDataAccessException(task + ";" + e.getMessage(), e);
        }
    }
}

