/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.securechannel;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.intercept.web.FilterInvocationDefinitionSource;
import org.springframework.security.securechannel.ChannelDecisionManager;
import org.springframework.security.ui.SpringSecurityFilter;
import org.springframework.util.Assert;

public class ChannelProcessingFilter
extends SpringSecurityFilter
implements InitializingBean {
    private ChannelDecisionManager channelDecisionManager;
    private FilterInvocationDefinitionSource filterInvocationDefinitionSource;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.filterInvocationDefinitionSource, (String)"filterInvocationDefinitionSource must be specified");
        Assert.notNull((Object)this.channelDecisionManager, (String)"channelDecisionManager must be specified");
        Collection attrDefs = this.filterInvocationDefinitionSource.getConfigAttributeDefinitions();
        if (attrDefs == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Could not validate configuration attributes as the FilterInvocationDefinitionSource did not return a ConfigAttributeDefinition Iterator");
            }
            return;
        }
        Iterator iter = attrDefs.iterator();
        HashSet<ConfigAttribute> set = new HashSet<ConfigAttribute>();
        while (iter.hasNext()) {
            ConfigAttributeDefinition def = (ConfigAttributeDefinition)iter.next();
            Iterator attributes = def.getConfigAttributes().iterator();
            while (attributes.hasNext()) {
                ConfigAttribute attr = (ConfigAttribute)attributes.next();
                if (this.channelDecisionManager.supports(attr)) continue;
                set.add(attr);
            }
        }
        if (set.size() == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Validated configuration attributes");
            }
        } else {
            throw new IllegalArgumentException("Unsupported configuration attributes: " + ((Object)set).toString());
        }
    }

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, chain);
        ConfigAttributeDefinition attr = this.filterInvocationDefinitionSource.getAttributes(fi);
        if (attr != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Request: " + fi.toString() + "; ConfigAttributes: " + attr.toString()));
            }
            this.channelDecisionManager.decide(fi, attr);
            if (fi.getResponse().isCommitted()) {
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public ChannelDecisionManager getChannelDecisionManager() {
        return this.channelDecisionManager;
    }

    public FilterInvocationDefinitionSource getFilterInvocationDefinitionSource() {
        return this.filterInvocationDefinitionSource;
    }

    public void setChannelDecisionManager(ChannelDecisionManager channelDecisionManager) {
        this.channelDecisionManager = channelDecisionManager;
    }

    public void setFilterInvocationDefinitionSource(FilterInvocationDefinitionSource filterInvocationDefinitionSource) {
        this.filterInvocationDefinitionSource = filterInvocationDefinitionSource;
    }

    public int getOrder() {
        return 0;
    }
}

