/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.TargetResolver;

public abstract class OperationClient {
    protected AxisOperation axisOp;
    protected ServiceContext sc;
    protected Options options;
    protected OperationContext oc;
    protected Callback callback;
    protected AxisCallback axisCallback;
    protected boolean completed;

    protected OperationClient(AxisOperation axisOp, ServiceContext sc, Options options) {
        this.axisOp = axisOp;
        this.sc = sc;
        this.options = new Options(options);
        this.completed = false;
        this.oc = sc.createOperationContext(axisOp);
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public abstract void addMessageContext(MessageContext var1) throws AxisFault;

    public abstract MessageContext getMessageContext(String var1) throws AxisFault;

    public abstract void setCallback(Callback var1);

    public final void setCallback(AxisCallback callback) {
        this.axisCallback = callback;
    }

    public final void execute(boolean block) throws AxisFault {
        this.sc.setLastOperationContext(this.oc);
        this.executeImpl(block);
    }

    public abstract void executeImpl(boolean var1) throws AxisFault;

    public void reset() throws AxisFault {
        if (!this.completed) {
            throw new AxisFault(Messages.getMessage("cannotreset"));
        }
        this.oc = null;
        this.completed = false;
    }

    public void complete(MessageContext msgCtxt) throws AxisFault {
        TransportOutDescription trsout = msgCtxt.getTransportOut();
        if (trsout != null) {
            trsout.getSender().cleanup(msgCtxt);
        }
    }

    public OperationContext getOperationContext() {
        return this.oc;
    }

    protected void setMessageID(MessageContext mc) {
        String messageId = this.options.getMessageId();
        if (messageId == null || "".equals(messageId)) {
            messageId = UUIDGenerator.getUUID();
        }
        mc.setMessageID(messageId);
    }

    protected void addReferenceParameters(MessageContext msgctx) {
        Map<QName, OMElement> map;
        EndpointReference tepr;
        EndpointReference to = msgctx.getTo();
        if ((this.options.isManageSession() || this.options.getParent() != null && this.options.getParent().isManageSession()) && (tepr = this.sc.getTargetEPR()) != null && (map = tepr.getAllReferenceParameters()) != null) {
            for (OMElement refparaelement : map.values()) {
                if (!(refparaelement instanceof OMElement)) continue;
                to.addReferenceParameter(refparaelement);
            }
        }
    }

    protected void prepareMessageContext(ConfigurationContext configurationContext, MessageContext mc) throws AxisFault {
        TransportOutDescription senderTransport;
        if (mc.getSoapAction() == null || "".equals(mc.getSoapAction())) {
            mc.setSoapAction(this.options.getAction());
        }
        mc.setOptions(new Options(this.options));
        mc.setAxisMessage(this.axisOp.getMessage("Out"));
        TargetResolver targetResolver = configurationContext.getAxisConfiguration().getTargetResolverChain();
        if (targetResolver != null) {
            targetResolver.resolveTarget(mc);
        }
        if ((senderTransport = this.options.getTransportOut()) == null) {
            EndpointReference toEPR = this.options.getTo() != null ? this.options.getTo() : mc.getTo();
            senderTransport = ClientUtils.inferOutTransport(configurationContext.getAxisConfiguration(), toEPR, mc);
        }
        mc.setTransportOut(senderTransport);
        if (this.options.getParent() != null && this.options.getParent().isManageSession()) {
            mc.getOptions().setManageSession(true);
        } else if (this.options.isManageSession()) {
            mc.getOptions().setManageSession(true);
        }
        this.addReferenceParameters(mc);
    }
}

