/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.webapp.http.core.FlowExecutionHandler;
import java.io.IOException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.executor.FlowExecutionResult;

public class ServletFlowExecutionHandler
implements FlowExecutionHandler {
    private static Log log = LogFactory.getLog((Class)ServletFlowExecutionHandler.class);
    private static final String SERVLET_RELATIVE_LOCATION_PREFIX = "servletRelative:";
    private static final String CONTEXT_RELATIVE_LOCATION_PREFIX = "contextRelative:";
    private static final String SERVER_RELATIVE_LOCATION_PREFIX = "serverRelative:";
    private ExternalContext externalContext;
    private FlowExecutionResult result;
    private ServletExternalContext servletExternalContext;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private FacesContext facesContext;
    private FlowUrlHandler flowUrlHandler;

    public ServletFlowExecutionHandler(ExternalContext externalContext, FlowExecutionResult result, ServletExternalContext servletExternalContext, HttpServletRequest request, HttpServletResponse response, FacesContext facesContext) {
        this.externalContext = externalContext;
        this.result = result;
        this.servletExternalContext = servletExternalContext;
        this.request = request;
        this.response = response;
        this.facesContext = facesContext;
        this.flowUrlHandler = new DefaultFlowUrlHandler();
    }

    public void handleFlowExecutionResult() throws IOException {
        if (this.result.isPaused()) {
            if (this.servletExternalContext.getFlowExecutionRedirectRequested()) {
                this.sendFlowExecutionRedirect(this.result, this.servletExternalContext, this.request, this.response);
            } else if (this.servletExternalContext.getFlowDefinitionRedirectRequested()) {
                this.sendFlowDefinitionRedirect(this.result, this.servletExternalContext, this.request, this.response);
            } else if (this.servletExternalContext.getExternalRedirectRequested()) {
                this.sendExternalRedirect(this.servletExternalContext.getExternalRedirectUrl(), this.request, this.response);
            }
        } else if (this.result.isEnded()) {
            if (this.servletExternalContext.getFlowDefinitionRedirectRequested()) {
                this.sendFlowDefinitionRedirect(this.result, this.servletExternalContext, this.request, this.response);
            } else if (this.servletExternalContext.getExternalRedirectRequested()) {
                this.sendExternalRedirect(this.servletExternalContext.getExternalRedirectUrl(), this.request, this.response);
            } else {
                this.defaultHandleExecutionOutcome(this.result.getFlowId(), this.result.getOutcome(), this.request, this.response);
            }
        } else {
            throw new IllegalStateException("Execution result should have been one of [paused] or [ended]");
        }
    }

    protected void defaultHandleExecutionOutcome(String flowId, FlowExecutionOutcome outcome, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!response.isCommitted()) {
            response.sendRedirect(this.flowUrlHandler.createFlowDefinitionUrl(flowId, outcome.getOutput(), request));
        }
    }

    protected void defaultHandleExecutionOutcome(String flowId, FlowExecutionOutcome outcome, HttpServletRequest request, HttpServletResponse response, FacesContext facesContext) throws IOException {
        if (!response.isCommitted()) {
            this.sendRedirect(this.flowUrlHandler.createFlowDefinitionUrl(flowId, outcome.getOutput(), request), request, response, facesContext);
        }
    }

    private void sendFlowExecutionRedirect(FlowExecutionResult result, ServletExternalContext servletExternalContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url = this.flowUrlHandler.createFlowExecutionUrl(result.getFlowId(), result.getPausedKey(), request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending flow execution redirect to '" + url + "'"));
        }
        this.sendRedirect(url, request, response, this.facesContext);
    }

    private void sendFlowDefinitionRedirect(FlowExecutionResult result, ServletExternalContext servletExternalContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String flowId = servletExternalContext.getFlowRedirectFlowId();
        MutableAttributeMap input = servletExternalContext.getFlowRedirectFlowInput();
        if (result.isPaused()) {
            input.put("refererExecution", (Object)result.getPausedKey());
        }
        String url = this.flowUrlHandler.createFlowDefinitionUrl(flowId, (AttributeMap)input, request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending flow definition redirect to '" + url + "'"));
        }
        this.sendRedirect(url, request, response, this.facesContext);
    }

    private void sendExternalRedirect(String location, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending external redirect to '" + location + "'"));
        }
        if (location.startsWith(SERVLET_RELATIVE_LOCATION_PREFIX)) {
            this.sendServletRelativeRedirect(location.substring(SERVLET_RELATIVE_LOCATION_PREFIX.length()), request, response);
        } else if (location.startsWith(CONTEXT_RELATIVE_LOCATION_PREFIX)) {
            StringBuffer url = new StringBuffer(request.getContextPath());
            String contextRelativeUrl = location.substring(CONTEXT_RELATIVE_LOCATION_PREFIX.length());
            if (!contextRelativeUrl.startsWith("/")) {
                url.append('/');
            }
            url.append(contextRelativeUrl);
            this.sendRedirect(url.toString(), request, response, this.facesContext);
        } else if (location.startsWith(SERVER_RELATIVE_LOCATION_PREFIX)) {
            String url = location.substring(SERVER_RELATIVE_LOCATION_PREFIX.length());
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
            this.sendRedirect(url, request, response, this.facesContext);
        } else if (location.startsWith("http://") || location.startsWith("https://")) {
            this.sendRedirect(location, request, response, this.facesContext);
        } else {
            this.sendServletRelativeRedirect(location, request, response);
        }
    }

    private void sendServletRelativeRedirect(String location, HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer url = new StringBuffer(request.getContextPath());
        url.append(request.getServletPath());
        if (!location.startsWith("/")) {
            url.append('/');
        }
        url.append(location);
        this.sendRedirect(url.toString(), request, response, this.facesContext);
    }

    private void sendRedirect(String url, HttpServletRequest request, HttpServletResponse response, FacesContext facesContext) throws IOException {
        ExternalContext ec = null;
        if (facesContext != null && (ec = facesContext.getExternalContext()) != null) {
            ec.redirect(response.encodeRedirectURL(url));
        } else {
            response.setStatus(303);
            response.setHeader("Location", response.encodeRedirectURL(url));
        }
    }
}

