/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.loadbundle;

import com.icesoft.faces.utils.MessageUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class LoadBundle
extends UIOutput {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.LoadBundle";
    public static final String COMPONENT_FAMILY = "com.icesoft.faces.LoadBundle";
    private String basename;
    private String var;
    private transient Locale oldLocale;
    private transient String oldBasename = new String();
    private transient ResourceBundle bundle;
    private transient Map map;
    private transient Object[] values;

    public LoadBundle() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "com.icesoft.faces.LoadBundle";
    }

    public String getComponentType() {
        return "com.icesoft.faces.LoadBundle";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        boolean reloadRequired;
        this.setRendererType(null);
        super.encodeBegin(context);
        String newBasename = this.getBasename();
        Locale currentLocale = context.getViewRoot().getLocale();
        boolean bl = reloadRequired = this.oldLocale == null || !this.oldLocale.getLanguage().equals(currentLocale.getLanguage()) || !this.oldBasename.equals(newBasename);
        if (reloadRequired) {
            this.bundle = ResourceBundle.getBundle(newBasename.trim(), currentLocale, MessageUtils.getClassLoader((Object)this));
            this.map = new Map(){

                public void clear() {
                    throw new UnsupportedOperationException();
                }

                public boolean containsKey(Object key) {
                    return null == key ? false : null != LoadBundle.this.bundle.getObject(key.toString());
                }

                public boolean containsValue(Object value) {
                    boolean found = false;
                    Object currentValue = null;
                    Enumeration<String> keys = LoadBundle.this.bundle.getKeys();
                    while (keys.hasMoreElements()) {
                        currentValue = LoadBundle.this.bundle.getObject(keys.nextElement());
                        if (value != currentValue && (null == currentValue || !currentValue.equals(value))) continue;
                        found = true;
                        break;
                    }
                    return found;
                }

                public Set entrySet() {
                    HashMap<String, Object> entries = new HashMap<String, Object>();
                    Enumeration<String> keys = LoadBundle.this.bundle.getKeys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        Object value = LoadBundle.this.bundle.getObject(key);
                        entries.put(key, value);
                    }
                    return entries.entrySet();
                }

                public Object get(Object key) {
                    if (null == key) {
                        return null;
                    }
                    Object result = null;
                    try {
                        result = LoadBundle.this.bundle.getObject(key.toString());
                    }
                    catch (MissingResourceException mre) {
                        result = "???" + key + "???";
                    }
                    return result;
                }

                public boolean isEmpty() {
                    return !LoadBundle.this.bundle.getKeys().hasMoreElements();
                }

                public Set keySet() {
                    HashSet<String> keySet = new HashSet<String>();
                    Enumeration<String> keys = LoadBundle.this.bundle.getKeys();
                    while (keys.hasMoreElements()) {
                        keySet.add(keys.nextElement());
                    }
                    return keySet;
                }

                public Object put(Object key, Object value) {
                    throw new UnsupportedOperationException();
                }

                public void putAll(Map t) {
                    throw new UnsupportedOperationException();
                }

                public Object remove(Object key) {
                    throw new UnsupportedOperationException();
                }

                public int size() {
                    int size = 0;
                    Enumeration<String> keys = LoadBundle.this.bundle.getKeys();
                    while (keys.hasMoreElements()) {
                        keys.nextElement();
                        ++size;
                    }
                    return size;
                }

                public Collection values() {
                    ArrayList<Object> values = new ArrayList<Object>();
                    Enumeration<String> keys = LoadBundle.this.bundle.getKeys();
                    while (keys.hasMoreElements()) {
                        values.add(LoadBundle.this.bundle.getObject(keys.nextElement()));
                    }
                    return values;
                }

                public int hashCode() {
                    return LoadBundle.this.bundle.hashCode();
                }
            };
            context.getExternalContext().getRequestMap().put(this.getVar(), this.map);
        }
        this.oldBasename = newBasename;
        this.oldLocale = currentLocale;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public String getBasename() {
        if (this.basename != null) {
            return this.basename;
        }
        ValueBinding vb = this.getValueBinding("basename");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[3];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this.basename;
        this.values[2] = this.var;
        return this.values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.basename = (String)values[1];
        this.var = (String)values[2];
    }
}

