/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.parser;

import com.icesoft.faces.webapp.parser.BodyContentImpl;
import com.icesoft.faces.webapp.parser.ComponentRuleSet;
import com.icesoft.faces.webapp.parser.JsfJspDigester;
import com.icesoft.faces.webapp.parser.JspWriterImpl;
import com.icesoft.faces.webapp.parser.StubPageContext;
import com.icesoft.faces.webapp.parser.TagToComponentMap;
import com.icesoft.faces.webapp.parser.TagWire;
import com.icesoft.faces.webapp.parser.XhtmlTag;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentBodyTag;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class Parser {
    private static final Log log = LogFactory.getLog((Class)Parser.class);
    private JsfJspDigester digester = new JsfJspDigester();
    private int indentIndex;

    public Parser(InputStream fis) throws IOException {
        this.digester.setNamespaceAware(true);
        this.digester.setValidating(false);
        this.digester.setUseContextClassLoader(false);
        this.digester.setClassLoader(this.getClass().getClassLoader());
        try {
            TagToComponentMap map = TagToComponentMap.loadFrom(fis);
            this.digester.addRuleSet((RuleSet)new ComponentRuleSet(map, ""));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader page, FacesContext context) throws IOException, SAXException {
        StubPageContext pageContext = new StubPageContext(context);
        HashSet componentIds = new HashSet();
        XhtmlTag rootTag = new XhtmlTag();
        rootTag.setTagName("ICEtag");
        rootTag.setParent(null);
        TagWire rootWire = new TagWire();
        rootWire.setTag((Tag)rootTag);
        TagWire realViewWire = null;
        String viewTagClassName = null;
        Parser parser = this;
        synchronized (parser) {
            this.digester.clear();
            this.digester.push((Object)rootTag);
            this.digester.push(rootWire);
            this.digester.parse(page);
            realViewWire = this.digester.getViewWire();
            viewTagClassName = this.digester.getViewTagClassName();
        }
        try {
            Tag viewTag;
            if (null != realViewWire) {
                viewTag = realViewWire.getTag();
                this.transmogrifyHierarchy(realViewWire, rootWire);
                viewTag.setParent(null);
            } else {
                if (null == viewTagClassName) {
                    throw new IllegalStateException("ICEfaces parser unable to determine JSF implementation ViewTag class.");
                }
                viewTag = (Tag)Class.forName(viewTagClassName).newInstance();
                rootWire.setTag(viewTag);
                realViewWire = rootWire;
                viewTag.setParent(null);
            }
            this.executeJspLifecycle(realViewWire, pageContext, context, componentIds);
            pageContext.removeAttribute("javax.faces.webapp.COMPONENT_TAG_STACK", 2);
            pageContext.removeAttribute("javax.faces.webapp.GLOBAL_ID_VIEW", 2);
        }
        catch (Exception e) {
            log.error((Object)"Failed to execute JSP lifecycle.", (Throwable)e);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Dumping Tag Hierarchy");
                if (realViewWire != null) {
                    this.displayHierarchy(realViewWire);
                } else {
                    this.displayHierarchy(rootWire);
                }
            }
            throw new FacesException("Failed to execute JSP lifecycle.", (Throwable)e);
        }
    }

    public void executeJspLifecycle(TagWire wire, PageContext pageContext, FacesContext facesContext, Set componentIds) throws JspException {
        Map attributes;
        ArrayList idsList;
        UIComponentTag compTag;
        boolean processingViewTag = false;
        Tag tag = wire.getTag();
        tag.setPageContext(pageContext);
        tag.doStartTag();
        UIComponent myComponent = null;
        if (tag instanceof UIComponentTag && (myComponent = (compTag = (UIComponentTag)tag).getComponentInstance()) != null) {
            String componentId;
            if (myComponent instanceof UIViewRoot) {
                myComponent.setId("_view");
                processingViewTag = true;
            }
            if (componentIds.contains(componentId = myComponent.getClientId(facesContext))) {
                throw new IllegalStateException("Duplicate component ID : " + componentId);
            }
            componentIds.add(componentId);
        }
        Iterator children = wire.getChildren().iterator();
        while (children.hasNext()) {
            TagWire childWire = (TagWire)children.next();
            this.executeJspLifecycle(childWire, pageContext, facesContext, componentIds);
        }
        if (!processingViewTag && tag instanceof UIComponentBodyTag) {
            UIComponentBodyTag bodyTag = (UIComponentBodyTag)tag;
            if (bodyTag.getBodyContent() == null) {
                JspWriterImpl jspWriter = new JspWriterImpl(new PrintWriter(System.out));
                BodyContentImpl imp = new BodyContentImpl(jspWriter);
                bodyTag.setBodyContent((BodyContent)imp);
            }
            bodyTag.doAfterBody();
        }
        tag.doEndTag();
        if (null != myComponent && null != (idsList = (ArrayList)(attributes = myComponent.getAttributes()).get("javax.faces.webapp.COMPONENT_IDS"))) {
            idsList.trimToSize();
        }
    }

    private void transmogrifyHierarchy(TagWire viewWire, TagWire rootWire) {
        Tag viewTag = viewWire.getTag();
        List rootChildren = rootWire.getChildren();
        if (rootChildren.size() == 0 || !((TagWire)rootChildren.get(0)).getTag().equals(viewTag)) {
            TagWire viewTagParent = this.findViewTagInHierarchy(viewWire, rootWire);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Replacing ViewTag in midst of hierarchy");
            }
            if (viewTagParent != null) {
                TagWire r;
                int idx;
                viewTagParent.replaceTagWireWithChildren(viewWire);
                List viewTagParentChildren = viewTagParent.getChildren();
                for (idx = 0; idx < viewTagParentChildren.size(); ++idx) {
                    r = (TagWire)viewTagParentChildren.get(idx);
                    r.getTag().setParent(viewTagParent.getTag());
                }
                rootChildren.remove(viewWire);
                viewWire.getChildren().clear();
                viewWire.getChildren().addAll(rootChildren);
                for (idx = 0; idx < rootChildren.size(); ++idx) {
                    r = (TagWire)rootChildren.get(idx);
                    r.getTag().setParent(viewTag);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"ViewTag is already at top of hierarchy");
        }
    }

    private TagWire findViewTagInHierarchy(TagWire toFind, TagWire parent) {
        List children = parent.getChildren();
        if (children.contains(toFind)) {
            return parent;
        }
        for (int idx = 0; idx < children.size(); ++idx) {
            TagWire child = this.findViewTagInHierarchy(toFind, (TagWire)children.get(idx));
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private void displayHierarchy(TagWire wire) {
        char[] pad = new char[this.indentIndex];
        Arrays.fill(pad, ' ');
        log.debug((Object)(new String(pad) + "Tag: " + wire.getTag()));
        this.indentIndex += 2;
        List children = wire.getChildren();
        for (int idx = 0; idx < children.size(); ++idx) {
            this.displayHierarchy((TagWire)children.get(idx));
        }
        this.indentIndex -= 2;
    }
}

