/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.net.messaging;

import com.icesoft.net.messaging.DefaultMessageService;
import com.icesoft.net.messaging.MessagePublisher;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.net.messaging.MessageServiceException;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueueMessagePublisher
implements MessagePublisher {
    private static final Log LOG = LogFactory.getLog((Class)QueueMessagePublisher.class);
    private static final Runnable NOOP = new Runnable(){

        public void run() {
        }
    };
    private final LinkedBlockingQueue messageQueue = new LinkedBlockingQueue();
    private final DefaultMessageService defaultMessageService;
    private final MessageServiceClient messageServiceClient;
    private final ScheduledFuture scheduledFuture;
    private boolean stopped = false;

    public QueueMessagePublisher(DefaultMessageService defaultMessageService, MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        this.defaultMessageService = defaultMessageService;
        this.messageServiceClient = messageServiceClient;
        this.scheduledFuture = scheduledThreadPoolExecutor.schedule(new Runnable(){

            public void run() {
                while (!QueueMessagePublisher.this.stopped) {
                    try {
                        ((Runnable)QueueMessagePublisher.this.messageQueue.take()).run();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                QueueMessagePublisher.this.messageQueue.clear();
                QueueMessagePublisher.this.scheduledFuture.cancel(false);
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public void publish(final Serializable objectMessage, final com.icesoft.util.Properties messageProperties, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    QueueMessagePublisher.this.messageServiceClient.publish(objectMessage, (Properties)messageProperties, topicName);
                }
            });
        }
    }

    public void publish(final Serializable objectMessage, final com.icesoft.util.Properties messageProperties, final String messageType, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    QueueMessagePublisher.this.messageServiceClient.publish(objectMessage, (Properties)messageProperties, messageType, topicName);
                }
            });
        }
    }

    public void publish(final Serializable objectMessage, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    QueueMessagePublisher.this.messageServiceClient.publish(objectMessage, topicName);
                }
            });
        }
    }

    public void publish(final Serializable objectMessage, final String messageType, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    QueueMessagePublisher.this.messageServiceClient.publish(objectMessage, messageType, topicName);
                }
            });
        }
    }

    public void publish(final String textMessage, final com.icesoft.util.Properties messageProperties, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    QueueMessagePublisher.this.messageServiceClient.publish(textMessage, (Properties)messageProperties, topicName);
                }
            });
        }
    }

    public void publish(final String textMessage, final com.icesoft.util.Properties messageProperties, final String messageType, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    QueueMessagePublisher.this.messageServiceClient.publish(textMessage, (Properties)messageProperties, messageType, topicName);
                }
            });
        }
    }

    public void publish(final String textMessage, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    QueueMessagePublisher.this.messageServiceClient.publish(textMessage, topicName);
                }
            });
        }
    }

    public void publish(final String textMessage, final String messageType, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    QueueMessagePublisher.this.messageServiceClient.publish(textMessage, messageType, topicName);
                }
            });
        }
    }

    public void publishNow(final Serializable objectMessage, final com.icesoft.util.Properties messageProperties, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    block2: {
                        try {
                            QueueMessagePublisher.this.messageServiceClient.publishNow(objectMessage, (Properties)messageProperties, topicName);
                        }
                        catch (MessageServiceException exception) {
                            if (!QueueMessagePublisher.this.defaultMessageService.reconnectNow()) break block2;
                            this.run();
                        }
                    }
                }
            });
        }
    }

    public void publishNow(final Serializable objectMessage, final com.icesoft.util.Properties messageProperties, final String messageType, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    block2: {
                        try {
                            QueueMessagePublisher.this.messageServiceClient.publishNow(objectMessage, (Properties)messageProperties, messageType, topicName);
                        }
                        catch (MessageServiceException exception) {
                            if (!QueueMessagePublisher.this.defaultMessageService.reconnectNow()) break block2;
                            this.run();
                        }
                    }
                }
            });
        }
    }

    public void publishNow(final Serializable objectMessage, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    block2: {
                        try {
                            QueueMessagePublisher.this.messageServiceClient.publishNow(objectMessage, topicName);
                        }
                        catch (MessageServiceException exception) {
                            if (!QueueMessagePublisher.this.defaultMessageService.reconnectNow()) break block2;
                            this.run();
                        }
                    }
                }
            });
        }
    }

    public void publishNow(final Serializable objectMessage, final String messageType, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    block2: {
                        try {
                            QueueMessagePublisher.this.messageServiceClient.publishNow(objectMessage, messageType, topicName);
                        }
                        catch (MessageServiceException exception) {
                            if (!QueueMessagePublisher.this.defaultMessageService.reconnectNow()) break block2;
                            this.run();
                        }
                    }
                }
            });
        }
    }

    public void publishNow(final String textMessage, final com.icesoft.util.Properties messageProperties, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    block2: {
                        try {
                            QueueMessagePublisher.this.messageServiceClient.publishNow(textMessage, (Properties)messageProperties, topicName);
                        }
                        catch (MessageServiceException exception) {
                            if (!QueueMessagePublisher.this.defaultMessageService.reconnectNow()) break block2;
                            this.run();
                        }
                    }
                }
            });
        }
    }

    public void publishNow(final String textMessage, final com.icesoft.util.Properties messageProperties, final String messageType, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    block2: {
                        try {
                            QueueMessagePublisher.this.messageServiceClient.publishNow(textMessage, (Properties)messageProperties, messageType, topicName);
                        }
                        catch (MessageServiceException exception) {
                            if (!QueueMessagePublisher.this.defaultMessageService.reconnectNow()) break block2;
                            this.run();
                        }
                    }
                }
            });
        }
    }

    public void publishNow(final String textMessage, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    block2: {
                        try {
                            QueueMessagePublisher.this.messageServiceClient.publishNow(textMessage, topicName);
                        }
                        catch (MessageServiceException exception) {
                            if (!QueueMessagePublisher.this.defaultMessageService.reconnectNow()) break block2;
                            this.run();
                        }
                    }
                }
            });
        }
    }

    public void publishNow(final String textMessage, final String messageType, final String topicName) {
        if (!this.stopped) {
            this.messageQueue.offer((Object)new Runnable(){

                public void run() {
                    block2: {
                        try {
                            QueueMessagePublisher.this.messageServiceClient.publishNow(textMessage, messageType, topicName);
                        }
                        catch (MessageServiceException exception) {
                            if (!QueueMessagePublisher.this.defaultMessageService.reconnectNow()) break block2;
                            this.run();
                        }
                    }
                }
            });
        }
    }

    public void stop() {
        this.stopped = true;
        this.messageQueue.offer((Object)NOOP);
    }
}

