#!/usr/bin/env python
# -*- coding: utf-8 -*-
'''
Created on 10.07.2009

@author: hmueller

Syntax description of bacula config files
'''

from simpleparse.common import numbers, strings, comments
from simpleparse.parser import Parser

import resource

declaration = r"""
#text_pattern	:= ’\/’
#text_subst	:= delim_init / ’/’
#text_args	:= delim_init / ’)’
#text_exp	:= delim_init / delim_close / ’:’ / ’+’
text		:= delim_init / index_open /index_close
delim_init	:= '$'
delim_open	:= '{'
delim_close	:= '}'
index_open	:= '['
index_close	:= ']'
index_mark	:= '#'
name_chars	:= [a-zA-Z0-9]
"""

if __name__ == "__main__":
    parser = Parser(declaration)
    
#input      ::= ( TEXT
#               | variable
#               | INDEX_OPEN input INDEX_CLOSE (loop_limits)?
#               )*
#variable   ::= DELIM_INIT (name|expression)
#name       ::= (NAME_CHARS)+
#expression ::= DELIM_OPEN
#               (name|variable)+
#               (INDEX_OPEN num_exp INDEX_CLOSE)?
#               (’:’ command)*
#               DELIM_CLOSE
#command    ::= ’-’ (TEXT_EXP|variable)+
#             | ’+’ (TEXT_EXP|variable)+
#             | ’o’ NUMBER (’-’|’,’) (NUMBER)?
#             | ’#’
#             | ’*’ (TEXT_EXP|variable)+
#             | ’s’ ’/’ (TEXT_PATTERN)+
#                   ’/’ (variable|TEXT_SUBST)*
#                   ’/’ (’m’|’g’|’i’|’t’)*
#               | ’y’ ’/’ (variable|TEXT_SUBST)+
#                     ’/’ (variable|TEXT_SUBST)*
#                     ’/’
#               | ’p’ ’/’ NUMBER
#                     ’/’ (variable|TEXT_SUBST)*
#                     ’/’ (’r’|’l’|’c’)
#               | ’%’ (name|variable)+
#                     (’(’ (TEXT_ARGS)? ’)’)?
#               | ’l’
#               | ’u’
# num_exp     ::= operand
#               | operand (’+’|’-’|’*’|’/’|’%’) num_exp
# operand     ::= (’+’|’-’)? NUMBER
#               | INDEX_MARK
#               | ’(’ num_exp ’)’
#               | variable
# loop_limits ::= DELIM_OPEN
#                 (num_exp)? ’,’ (num_exp)? (’,’ (num_exp)?)?
#                 DELIM_CLOSE
# NUMBER      ::= (’0’|...|’9’)+
# TEXT_PATTERN::= (^(’/’))+
# TEXT_SUBST ::= (^(DELIM_INIT|’/’))+
# TEXT_ARGS   ::= (^(DELIM_INIT|’)’))+
# TEXT_EXP    ::= (^(DELIM_INIT|DELIM_CLOSE|’:’|’+’))+
# TEXT        ::= (^(DELIM_INIT|INDEX_OPEN|INDEX_CLOSE))+
# DELIM_INIT ::= ’$’
# DELIM_OPEN ::= ’{’
# DELIM_CLOSE ::= ’}’
# INDEX_OPEN ::= ’[’
# INDEX_CLOSE ::= ’]’
# INDEX_MARK ::= ’#’
# NAME_CHARS ::= ’a’|...|’z’|’A’|...|’Z’|’0’|...|’9’

