/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.rememberme;

import java.io.Serializable;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.springframework.util.Assert;

public class RememberMeAuthenticationToken
extends AbstractAuthenticationToken
implements Serializable {
    private Object principal;
    private int keyHash;

    public RememberMeAuthenticationToken(String key, Object principal, GrantedAuthority[] authorities) {
        super(authorities);
        if (key == null || "".equals(key) || principal == null || "".equals(principal) || authorities == null || authorities.length == 0) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        for (int i = 0; i < authorities.length; ++i) {
            Assert.notNull((Object)authorities[i], (String)("Granted authority element " + i + " is null - GrantedAuthority[] cannot contain any null elements"));
        }
        this.keyHash = key.hashCode();
        this.principal = principal;
        this.setAuthenticated(true);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof RememberMeAuthenticationToken) {
            RememberMeAuthenticationToken test = (RememberMeAuthenticationToken)obj;
            return this.getKeyHash() == test.getKeyHash();
        }
        return false;
    }

    public Object getCredentials() {
        return "";
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    public Object getPrincipal() {
        return this.principal;
    }
}

