/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.application.ProductInfo;
import com.icesoft.faces.util.event.servlet.AnnouncementMessageHandler;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.servlet.DisposeViewsMessageHandler;
import com.icesoft.net.messaging.AbstractMessageHandler;
import com.icesoft.net.messaging.DefaultMessageService;
import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageHandler;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.net.messaging.MessageServiceException;
import com.icesoft.net.messaging.TextMessage;
import com.icesoft.net.messaging.expression.Equal;
import com.icesoft.net.messaging.expression.Identifier;
import com.icesoft.net.messaging.expression.Or;
import com.icesoft.net.messaging.expression.StringLiteral;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoreMessageService
extends DefaultMessageService {
    private static final Log LOG = LogFactory.getLog((Class)CoreMessageService.class);
    private final AcknowledgeMessageHandler acknowledgeMessageHandler = new AcknowledgeMessageHandler(this);
    private final AnnouncementMessageHandler announcementMessageHandler = new AnnouncementMessageHandler();
    private final DisposeViewsMessageHandler disposeViewsMessageHandler = new DisposeViewsMessageHandler();
    private final String blockingRequestHandlerContext;

    public CoreMessageService(MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, String blockingRequestHandlerContext) throws IllegalArgumentException {
        super(messageServiceClient, scheduledThreadPoolExecutor);
        this.blockingRequestHandlerContext = blockingRequestHandlerContext;
    }

    public CoreMessageService(MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, boolean retryOnFail, String blockingRequestHandlerContext) throws IllegalArgumentException {
        super(messageServiceClient, scheduledThreadPoolExecutor, retryOnFail);
        this.blockingRequestHandlerContext = blockingRequestHandlerContext;
    }

    public CoreMessageService(MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, Configuration configuration, String blockingRequestHandlerContext) throws IllegalArgumentException {
        super(messageServiceClient, scheduledThreadPoolExecutor, configuration);
        this.blockingRequestHandlerContext = blockingRequestHandlerContext;
    }

    public CoreMessageService(MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, Configuration configuration, boolean retryOnFail, String blockingRequestHandlerContext) throws IllegalArgumentException {
        super(messageServiceClient, scheduledThreadPoolExecutor, configuration, retryOnFail);
        this.blockingRequestHandlerContext = blockingRequestHandlerContext;
    }

    public AcknowledgeMessageHandler getAcknowledgeMessageHandler() {
        return this.acknowledgeMessageHandler;
    }

    public AnnouncementMessageHandler getAnnouncementMessageHandler() {
        return this.announcementMessageHandler;
    }

    public DisposeViewsMessageHandler getDisposeViewsMessageHandler() {
        return this.disposeViewsMessageHandler;
    }

    protected void setUpMessageServiceClient() throws MessageServiceException {
        LOG.debug((Object)"Setting up Message Service Client...");
        try {
            this.getMessageServiceClient().subscribe("icefacesPush", this.acknowledgeMessageHandler.getMessageSelector());
            this.getMessageServiceClient().addMessageHandler(this.acknowledgeMessageHandler, "icefacesPush");
            this.getMessageServiceClient().start();
            com.icesoft.util.Properties _messageProperties = new com.icesoft.util.Properties();
            _messageProperties.setStringProperty("destination_servletContextPath", this.blockingRequestHandlerContext);
            this.getMessageServiceClient().publishNow("Hello", (Properties)_messageProperties, "Presence", "icefacesPush");
        }
        catch (MessageServiceException exception) {
            try {
                this.getMessageServiceClient().stop();
            }
            catch (MessageServiceException e) {
                // empty catch block
            }
            this.getMessageServiceClient().removeMessageHandler(this.acknowledgeMessageHandler, "icefacesPush");
            try {
                this.getMessageServiceClient().unsubscribe("icefacesPush");
            }
            catch (MessageServiceException messageServiceException) {
                // empty catch block
            }
            throw exception;
        }
        this.getMessageServiceClient().subscribe("icefacesPush", new MessageSelector(new Or(this.announcementMessageHandler.getMessageSelector().getExpression(), this.disposeViewsMessageHandler.getMessageSelector().getExpression())));
        this.getMessageServiceClient().addMessageHandler(this.announcementMessageHandler, "icefacesPush");
        this.getMessageServiceClient().addMessageHandler(this.disposeViewsMessageHandler, "icefacesPush");
    }

    protected void tearDownMessageServiceClient() throws MessageServiceException {
        LOG.debug((Object)"Tearing down Message Service Client...");
        this.getMessageServiceClient().removeMessageHandler(this.disposeViewsMessageHandler, "icefacesPush");
        this.getMessageServiceClient().removeMessageHandler(this.announcementMessageHandler, "icefacesPush");
        this.getMessageServiceClient().unsubscribe("icefacesPush");
    }

    public static class AcknowledgeMessageHandler
    extends AbstractMessageHandler
    implements MessageHandler {
        private static MessageSelector messageSelector = new MessageSelector(new Equal(new Identifier("message_type"), new StringLiteral("Presence")));
        private final CoreMessageService coreMessageService;

        private AcknowledgeMessageHandler(CoreMessageService coreMessageService) {
            super(messageSelector);
            this.coreMessageService = coreMessageService;
        }

        public void handle(Message message) {
            if (message instanceof TextMessage) {
                String _text = ((TextMessage)message).getText();
                int _begin = 0;
                int _end = _text.indexOf(";");
                if (_end != -1 && _text.substring(_begin, _end).equals("Acknowledge")) {
                    _begin = _end + 1;
                    _end = _text.indexOf(";", _begin);
                    String _product = _text.substring(_begin, _end);
                    _begin = _end + 1;
                    _end = _text.indexOf(";", _begin);
                    String _primary = _text.substring(_begin, _end);
                    _begin = _end + 1;
                    _end = _text.indexOf(";", _begin);
                    String _secondary = _text.substring(_begin, _end);
                    _begin = _end + 1;
                    _end = _text.indexOf(";", _begin);
                    String _tertiary = _text.substring(_begin, _end);
                    _begin = _end + 1;
                    _end = _text.indexOf(";", _begin);
                    String _releaseType = _text.substring(_begin, _end);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Push Server detected: \"" + _product + " " + _primary + "." + _secondary + "." + _tertiary + (_releaseType.length() == 0 ? _releaseType : " " + _releaseType) + "\""));
                    }
                    if (!(!LOG.isWarnEnabled() || _primary.equals("x") || ProductInfo.PRIMARY.equals("x") || _primary.equals(ProductInfo.PRIMARY) && _secondary.equals(ProductInfo.SECONDARY) && _tertiary.equals(ProductInfo.TERTIARY))) {
                        LOG.warn((Object)("ICEfaces / Push Server version mismatch! - Using \"" + ProductInfo.PRODUCT + " " + ProductInfo.PRIMARY + "." + ProductInfo.SECONDARY + "." + ProductInfo.TERTIARY + "\" " + "with \"" + _product + " " + _primary + "." + _secondary + "." + _tertiary + "\" " + "is not recommended."));
                    }
                    this.coreMessageService.getMessageServiceClient().removeMessageHandler(this, "icefacesPush");
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)"Using Push Server Blocking Request Handler");
                    }
                    MessageHandler.Callback[] _callbacks = this.getCallbacks(message);
                    for (int i = 0; i < _callbacks.length; ++i) {
                        ((Callback)_callbacks[i]).acknowledge(_product, _primary, _secondary, _tertiary, _releaseType);
                    }
                }
            }
        }

        public static interface Callback
        extends MessageHandler.Callback {
            public void acknowledge(String var1, String var2, String var3, String var4, String var5);
        }
    }
}

