/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.io.IoHelper;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.History;
import de.hunsicker.util.ResourceBundleFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class HistoryViewer
extends JPanel {
    DateFormat _dateFormatter = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
    private DefaultTreeModel _treeModel;
    HistoryTreeNode _rootNode;
    JTree _tree;
    boolean _caseSensitive;

    public HistoryViewer() {
        this.initialize();
    }

    public void removeNotify() {
        super.removeNotify();
        try {
            History.getInstance().flush();
        }
        catch (IOException ignored) {}
    }

    private int getIndex(HistoryTreeNode node, HistoryTreeNode parent) {
        int result = 0;
        Enumeration<TreeNode> childs = parent.children();
        while (childs.hasMoreElements()) {
            HistoryTreeNode child = (HistoryTreeNode)childs.nextElement();
            int compare = node.compareTo(child);
            if (compare < 0) break;
            ++result;
        }
        return result;
    }

    private void addAsChild(HistoryTreeNode parent, String path, History.Entry entry) {
        int offset = path.indexOf(File.separatorChar);
        if (offset > -1) {
            String ident = path.substring(0, offset);
            int index = this.contains(parent, ident);
            if (index > -1) {
                this.addAsChild((HistoryTreeNode)parent.getChildAt(index), path.substring(offset + 1), entry);
            } else {
                HistoryTreeNode node = new HistoryTreeNode(ident);
                this._treeModel.insertNodeInto(node, parent, this.getIndex(node, parent));
                this.addAsChild(node, path.substring(offset + 1), entry);
            }
        } else {
            HistoryTreeNode node = new HistoryTreeNode(path, entry.getModification());
            if (this.contains(parent, node) == -1) {
                this._treeModel.insertNodeInto(node, parent, this.getIndex(node, parent));
            }
        }
    }

    private int contains(HistoryTreeNode parent, HistoryTreeNode child) {
        return this.contains(parent, child.name);
    }

    private int contains(HistoryTreeNode parent, String name) {
        Enumeration<TreeNode> i = parent.children();
        while (i.hasMoreElements()) {
            HistoryTreeNode c = (HistoryTreeNode)i.nextElement();
            if (!(this._caseSensitive ? c.name.equals(name) : c.name.equalsIgnoreCase(name))) continue;
            return parent.getIndex(c);
        }
        return -1;
    }

    private void initialize() {
        ResourceBundle bundle = ResourceBundleFactory.getBundle("de.hunsicker.jalopy.swing.Bundle");
        this.setPreferredSize(new Dimension(350, 400));
        this._caseSensitive = File.separatorChar == '/';
        this._rootNode = new HistoryTreeNode(bundle.getString("TLE_HISTORY"));
        this._tree = new JTree(this._rootNode);
        this._tree.putClientProperty("JTree.lineStyle", "Angled");
        this._tree.setScrollsOnExpand(true);
        this._tree.setLargeModel(true);
        HistoryTreeCellRenderer r = new HistoryTreeCellRenderer();
        this._tree.setCellRenderer(r);
        this._treeModel = (DefaultTreeModel)this._tree.getModel();
        JScrollPane scrollPane = new JScrollPane(this._tree);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        final JPopupMenu popupMenu = new JPopupMenu();
        JPopupMenu.setDefaultLightWeightPopupEnabled(true);
        popupMenu.setLightWeightPopupEnabled(true);
        final RemoveItemAction removeAction = new RemoveItemAction();
        removeAction.setEnabled(false);
        popupMenu.add(removeAction);
        this._tree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent ev) {
                if (ev.isPopupTrigger()) {
                    Object selection = HistoryViewer.this._tree.getLastSelectedPathComponent();
                    if (selection != null && selection != HistoryViewer.this._rootNode) {
                        removeAction.setEnabled(true);
                    } else {
                        removeAction.setEnabled(false);
                    }
                    Point point = new Point(ev.getX(), ev.getY());
                    SwingUtilities.convertPointToScreen(point, HistoryViewer.this._tree);
                    popupMenu.setInvoker(HistoryViewer.this._tree);
                    popupMenu.setLocation(point.x, point.y);
                    popupMenu.setVisible(true);
                }
            }
        });
        Map history = this.loadHistory();
        this.populateTree(history);
        this._tree.expandRow(0);
    }

    private Map loadHistory() {
        HashMap history;
        block3: {
            history = null;
            try {
                File file = Convention.getHistoryFile();
                if (file.exists()) {
                    history = new HashMap((Map)IoHelper.deserialize(file));
                    break block3;
                }
                history = new HashMap();
            }
            catch (Throwable ex) {
                history = new HashMap();
            }
        }
        return history;
    }

    private void populateTree(Map history) {
        Iterator i = history.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.addAsChild(this._rootNode, (String)entry.getKey(), (History.Entry)entry.getValue());
        }
    }

    private void removeChildren(TreePath path) {
        HistoryTreeNode node = (HistoryTreeNode)path.getLastPathComponent();
        this.removeChildren(node);
    }

    private void removeChildren(HistoryTreeNode node) {
        if (node.isLeaf()) {
            try {
                History.getInstance().remove(node.toFile());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            Enumeration<TreeNode> i = node.children();
            while (i.hasMoreElements()) {
                this.removeChildren((HistoryTreeNode)i.nextElement());
            }
        }
    }

    void removePath(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent != null) {
            this.removeChildren(path);
            this._treeModel.removeNodeFromParent((HistoryTreeNode)path.getLastPathComponent());
        }
    }

    private class RemoveItemAction
    extends AbstractAction {
        public RemoveItemAction() {
            super.putValue("Name", ResourceBundleFactory.getBundle("de.hunsicker.jalopy.swing.Bundle").getString("MNE_REMOVE"));
        }

        public void actionPerformed(ActionEvent ev) {
            TreePath[] selections = HistoryViewer.this._tree.getSelectionPaths();
            if (selections != null) {
                int i = 0;
                while (i < selections.length) {
                    TreePath selection = selections[i];
                    HistoryViewer.this.removePath(selection);
                    ++i;
                }
            }
        }
    }

    private class HistoryTreeNode
    extends DefaultMutableTreeNode
    implements Comparable {
        String name;
        long lastmod = -1L;

        public HistoryTreeNode(String name) {
            this.name = name;
        }

        public HistoryTreeNode(String name, long lastmod) {
            this.lastmod = lastmod;
            this.name = name;
        }

        public int compareTo(Object o) {
            if (o instanceof String) {
                return this.name.compareTo((String)o);
            }
            if (o instanceof HistoryTreeNode) {
                return this.name.compareTo(((HistoryTreeNode)o).name);
            }
            throw new ClassCastException();
        }

        public boolean equals(Object o) {
            if (o instanceof String) {
                if (HistoryViewer.this._caseSensitive) {
                    return this.name.equals(o);
                }
                return this.name.equalsIgnoreCase((String)o);
            }
            if (HistoryViewer.this._caseSensitive) {
                return this.name.equals(((HistoryTreeNode)o).name);
            }
            return this.name.equalsIgnoreCase(((HistoryTreeNode)o).name);
        }

        public int hashCode() {
            if (HistoryViewer.this._caseSensitive) {
                return this.name.hashCode();
            }
            return this.name.toLowerCase().hashCode();
        }

        public File toFile() {
            StringBuffer buf = new StringBuffer(50);
            TreeNode[] p = this.getPath();
            int i = 1;
            while (i < p.length) {
                buf.append(p[i]);
                buf.append(File.separatorChar);
                ++i;
            }
            buf.deleteCharAt(buf.length() - 1);
            String filename = buf.toString();
            if (filename.endsWith("]")) {
                filename = filename.substring(0, filename.lastIndexOf(91));
            }
            return new File(filename);
        }

        public String toString() {
            if (this.lastmod > -1L) {
                StringBuffer buf = new StringBuffer(20);
                buf.append(this.name);
                buf.append(' ');
                buf.append('[');
                buf.append(HistoryViewer.this._dateFormatter.format(new Date(this.lastmod)));
                buf.append(']');
                return buf.toString();
            }
            return this.name;
        }
    }

    private static class HistoryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        Icon rootIcon = new ImageIcon(this.getClass().getResource("resources/History16.gif"));

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean newHasFocus) {
            if (row == 0) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, newHasFocus);
                this.setIcon(this.rootIcon);
                return this;
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, newHasFocus);
        }
    }
}

