/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.ViewListener;
import com.icesoft.faces.env.Authorization;
import com.icesoft.faces.facelets.FaceletsUIDebug;
import com.icesoft.faces.util.event.servlet.ContextEventRepeater;
import com.icesoft.faces.webapp.command.Command;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.NOOP;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.standard.NoCacheContentHandler;
import com.icesoft.faces.webapp.http.core.LifecycleExecutor;
import com.icesoft.faces.webapp.http.core.ResourceDispatcher;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.faces.webapp.parser.ImplementationUtil;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.util.SeamUtilities;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class View
implements CommandQueue {
    public static final String ICEFACES_STATE_MAPS = "icefaces.state.maps";
    private static final Log Log = LogFactory.getLog((Class)View.class);
    private static final NOOP NOOP = new NOOP();
    private static final Runnable DoNothing = new Runnable(){

        public void run() {
        }
    };
    private final Page lifecycleExecutedPage;
    private Page page;
    private final ReentrantLock queueLock;
    private final ReentrantLock lifecycleLock;
    private BridgeFacesContext facesContext;
    private PersistentFacesState persistentFacesState;
    private Command currentCommand;
    private final String viewIdentifier;
    private final Collection viewListeners;
    private final String sessionID;
    private final HttpSession session;
    private final Configuration configuration;
    private final SessionDispatcher.Monitor sessionMonitor;
    private final ResourceDispatcher resourceDispatcher;
    private Runnable dispose;
    private final ViewQueue allServedViews;
    private String blockingRequestHandlerContext;
    private Authorization authorization;
    private final ArrayList onReleaseListeners;

    public View(final String viewIdentifier, String sessionID, HttpSession session, final ViewQueue allServedViews, Configuration configuration, SessionDispatcher.Monitor sessionMonitor, ResourceDispatcher resourceDispatcher, String blockingRequestHandlerContext, Authorization authorization) throws Exception {
        this.page = this.lifecycleExecutedPage = new Page(){
            private String lastPath;
            private final ResponseHandler lifecycleResponseHandler = new NoCacheContentHandler("text/html", "UTF-8"){

                public void respond(Response response) throws Exception {
                    super.respond(response);
                    View.this.facesContext.switchToNormalMode();
                    LifecycleExecutor.getLifecycleExecutor(View.this.facesContext).apply(View.this.facesContext);
                    View.this.facesContext.switchToPushMode();
                }
            };

            public void serve(Request request) throws Exception {
                if (FaceletsUIDebug.handleRequest(View.this.session, request)) {
                    return;
                }
                String path = request.getURI().getPath();
                boolean reloded = path.equals(this.lastPath);
                this.lastPath = path;
                if (reloded && !SeamUtilities.isSeamEnvironment()) {
                    View.this.facesContext.reload(request);
                } else {
                    if (View.this.facesContext != null) {
                        View.this.facesContext.dispose();
                    }
                    if (ImplementationUtil.isJSF2()) {
                        Class<?> bfc2Class = Class.forName("org.icefaces.x.context.BridgeFacesContext2");
                        Constructor<?> bfc2Constructor = bfc2Class.getConstructors()[0];
                        View.this.facesContext = (BridgeFacesContext)bfc2Constructor.newInstance(request, View.this.viewIdentifier, View.this.sessionID, View.this, View.this.configuration, View.this.resourceDispatcher, View.this.sessionMonitor, View.this.blockingRequestHandlerContext, View.this.authorization);
                    } else {
                        View.this.facesContext = new BridgeFacesContext(request, View.this.viewIdentifier, View.this.sessionID, View.this, View.this.configuration, View.this.resourceDispatcher, View.this.sessionMonitor, View.this.blockingRequestHandlerContext, View.this.authorization);
                    }
                }
                View.this.makeCurrent();
                try {
                    request.respondWith(this.lifecycleResponseHandler);
                }
                catch (Exception e) {
                    String viewID = "Unknown View";
                    try {
                        viewID = View.this.facesContext.getViewRoot().getViewId();
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                    Log.error((Object)("Exception occured during rendering on " + request.getURI() + " [" + viewID + "]"), (Throwable)e);
                    throw e;
                }
            }
        };
        this.queueLock = new ReentrantLock();
        this.lifecycleLock = new ReentrantLock();
        this.currentCommand = NOOP;
        this.viewListeners = new ArrayList();
        this.onReleaseListeners = new ArrayList();
        this.sessionID = sessionID;
        this.session = session;
        this.configuration = configuration;
        this.viewIdentifier = viewIdentifier;
        this.sessionMonitor = sessionMonitor;
        this.resourceDispatcher = resourceDispatcher;
        this.allServedViews = allServedViews;
        this.blockingRequestHandlerContext = blockingRequestHandlerContext;
        this.authorization = authorization;
        this.persistentFacesState = new PersistentFacesState(this, this.viewListeners, configuration);
        ContextEventRepeater.viewNumberRetrieved(session, sessionID, Integer.parseInt(viewIdentifier));
        this.dispose = new Runnable(){

            public void run() {
                View.this.dispose = DoNothing;
                Log.debug((Object)("Disposing " + this));
                View.this.installThreadLocals();
                View.this.notifyViewDisposal();
                View.this.releaseAll();
                View.this.releaseLifecycleLockUnconditionally();
                View.this.persistentFacesState.dispose();
                View.this.facesContext.dispose();
                allServedViews.remove(viewIdentifier);
            }
        };
        Log.debug((Object)("Created " + this));
    }

    public void processPostback(Request request) throws Exception {
        this.acquireLifecycleLock();
        this.facesContext.processPostback(request);
        this.makeCurrent();
    }

    public void servePage(Request request) throws Exception {
        try {
            this.acquireLifecycleLock();
            this.page.serve(request);
        }
        catch (Throwable t) {
            Log.error((Object)"Problem encountered during View.servePage ", t);
            throw new Exception(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Command command) {
        this.queueLock.lock();
        try {
            this.currentCommand = this.currentCommand.coalesceWithNext(command);
        }
        finally {
            this.queueLock.unlock();
        }
        try {
            this.allServedViews.put(this.viewIdentifier);
        }
        catch (InterruptedException e) {
            Log.warn((Object)"Failed to queue updated view", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command take() {
        Command command = null;
        this.queueLock.lock();
        try {
            command = this.currentCommand;
            this.currentCommand = NOOP;
        }
        finally {
            this.queueLock.unlock();
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            this.releaseAll();
            this.notifyRelease();
        }
        finally {
            this.releaseLifecycleLock();
        }
    }

    private void releaseAll() {
        if (this.facesContext != null) {
            this.facesContext.release();
        }
        if (this.persistentFacesState != null) {
            this.persistentFacesState.release();
        }
        if (this.facesContext != null) {
            ((BridgeExternalContext)this.facesContext.getExternalContext()).release();
        }
    }

    public BridgeFacesContext getFacesContext() {
        return this.facesContext;
    }

    public PersistentFacesState getPersistentFacesState() {
        return this.persistentFacesState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.acquireLifecycleLock();
            this.dispose.run();
            ContextEventRepeater.viewNumberDisposed(this.facesContext.getExternalContext().getSession(false), this.sessionID, Integer.parseInt(this.viewIdentifier));
        }
        finally {
            this.releaseLifecycleLockUnconditionally();
        }
    }

    public void installThreadLocals() {
        this.persistentFacesState.setCurrentInstance();
        this.facesContext.setCurrentInstance();
    }

    public void acquireLifecycleLock() {
        if (!this.lifecycleLock.isHeldByCurrentThread()) {
            this.lifecycleLock.lock();
        }
    }

    public void releaseLifecycleLock() {
        this.lifecycleLock.lock();
        this.releaseLifecycleLockUnconditionally();
    }

    private void releaseLifecycleLockUnconditionally() {
        while (this.lifecycleLock.getHoldCount() > 0) {
            this.lifecycleLock.unlock();
        }
    }

    public String toString() {
        return "View[" + this.sessionID + ":" + this.viewIdentifier + "]";
    }

    void preparePage(final ResponseHandler handler) {
        this.page = new Page(){

            public void serve(Request request) throws Exception {
                request.respondWith(handler);
                View.this.page = View.this.lifecycleExecutedPage;
            }
        };
    }

    private void makeCurrent() throws Exception {
        this.acquireLifecycleLock();
        this.installThreadLocals();
        this.facesContext.injectBundles();
        this.facesContext.applyBrowserDOMChanges();
    }

    private void notifyViewDisposal() {
        Iterator i = this.viewListeners.iterator();
        while (i.hasNext()) {
            try {
                ViewListener listener = (ViewListener)i.next();
                listener.viewDisposed();
            }
            catch (Throwable t) {
                Log.warn((Object)"Failed to invoke view listener", t);
            }
        }
        Map sessionMap = this.facesContext.getExternalContext().getSessionMap();
        try {
            Map m = (Map)sessionMap.get(ICEFACES_STATE_MAPS);
            if (m != null) {
                m.remove(this.facesContext.getViewNumber());
            }
        }
        catch (Exception e) {
            Log.error((Object)("Exception cleaning up State Saving Map: " + e));
        }
    }

    private void notifyRelease() {
        Iterator i = this.onReleaseListeners.iterator();
        while (i.hasNext()) {
            Runnable runnable = (Runnable)i.next();
            runnable.run();
        }
    }

    public void onRelease(Runnable runnable) {
        this.onReleaseListeners.add(runnable);
    }

    private static interface Page {
        public void serve(Request var1) throws Exception;
    }
}

