/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.xmlpull.mxp1.MXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderManager {
    private static ProviderManager instance;
    private Map<String, Object> extensionProviders = new ConcurrentHashMap<String, Object>();
    private Map<String, Object> iqProviders = new ConcurrentHashMap<String, Object>();

    public static synchronized ProviderManager getInstance() {
        if (instance == null) {
            instance = new ProviderManager();
        }
        return instance;
    }

    public static synchronized void setInstance(ProviderManager providerManager) {
        if (instance != null) {
            throw new IllegalStateException("ProviderManager singleton already set");
        }
        instance = providerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        try {
            ClassLoader[] classLoaders;
            for (ClassLoader classLoader : classLoaders = this.getClassLoaders()) {
                Enumeration<URL> providerEnum = classLoader.getResources("META-INF/smack.providers");
                while (providerEnum.hasMoreElements()) {
                    URL url = providerEnum.nextElement();
                    InputStream providerStream = null;
                    try {
                        providerStream = url.openStream();
                        MXParser parser = new MXParser();
                        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                        parser.setInput(providerStream, "UTF-8");
                        int eventType = parser.getEventType();
                        do {
                            Class<?> provider;
                            String key;
                            String className;
                            String namespace;
                            String elementName;
                            if (eventType != 2) continue;
                            if (parser.getName().equals("iqProvider")) {
                                parser.next();
                                parser.next();
                                elementName = parser.nextText();
                                parser.next();
                                parser.next();
                                namespace = parser.nextText();
                                parser.next();
                                parser.next();
                                className = parser.nextText();
                                key = this.getProviderKey(elementName, namespace);
                                if (this.iqProviders.containsKey(key)) continue;
                                try {
                                    provider = Class.forName(className);
                                    if (IQProvider.class.isAssignableFrom(provider)) {
                                        this.iqProviders.put(key, provider.newInstance());
                                        continue;
                                    }
                                    if (!IQ.class.isAssignableFrom(provider)) continue;
                                    this.iqProviders.put(key, provider);
                                }
                                catch (ClassNotFoundException cnfe) {
                                    cnfe.printStackTrace();
                                }
                                continue;
                            }
                            if (!parser.getName().equals("extensionProvider")) continue;
                            parser.next();
                            parser.next();
                            elementName = parser.nextText();
                            parser.next();
                            parser.next();
                            namespace = parser.nextText();
                            parser.next();
                            parser.next();
                            className = parser.nextText();
                            key = this.getProviderKey(elementName, namespace);
                            if (this.extensionProviders.containsKey(key)) continue;
                            try {
                                provider = Class.forName(className);
                                if (PacketExtensionProvider.class.isAssignableFrom(provider)) {
                                    this.extensionProviders.put(key, provider.newInstance());
                                    continue;
                                }
                                if (!PacketExtension.class.isAssignableFrom(provider)) continue;
                                this.extensionProviders.put(key, provider);
                            }
                            catch (ClassNotFoundException cnfe) {
                                cnfe.printStackTrace();
                            }
                        } while ((eventType = parser.next()) != 1);
                    }
                    finally {
                        try {
                            providerStream.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getIQProvider(String elementName, String namespace) {
        String key = this.getProviderKey(elementName, namespace);
        return this.iqProviders.get(key);
    }

    public Collection<Object> getIQProviders() {
        return Collections.unmodifiableCollection(this.iqProviders.values());
    }

    public void addIQProvider(String elementName, String namespace, Object provider) {
        if (!(provider instanceof IQProvider || provider instanceof Class && IQ.class.isAssignableFrom((Class)provider))) {
            throw new IllegalArgumentException("Provider must be an IQProvider or a Class instance.");
        }
        String key = this.getProviderKey(elementName, namespace);
        this.iqProviders.put(key, provider);
    }

    public void removeIQProvider(String elementName, String namespace) {
        String key = this.getProviderKey(elementName, namespace);
        this.iqProviders.remove(key);
    }

    public Object getExtensionProvider(String elementName, String namespace) {
        String key = this.getProviderKey(elementName, namespace);
        return this.extensionProviders.get(key);
    }

    public void addExtensionProvider(String elementName, String namespace, Object provider) {
        if (!(provider instanceof PacketExtensionProvider) && !(provider instanceof Class)) {
            throw new IllegalArgumentException("Provider must be a PacketExtensionProvider or a Class instance.");
        }
        String key = this.getProviderKey(elementName, namespace);
        this.extensionProviders.put(key, provider);
    }

    public void removeExtensionProvider(String elementName, String namespace) {
        String key = this.getProviderKey(elementName, namespace);
        this.extensionProviders.remove(key);
    }

    public Collection<Object> getExtensionProviders() {
        return Collections.unmodifiableCollection(this.extensionProviders.values());
    }

    private String getProviderKey(String elementName, String namespace) {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(elementName).append("/><").append(namespace).append("/>");
        return buf.toString();
    }

    private ClassLoader[] getClassLoaders() {
        ClassLoader[] classLoaders = new ClassLoader[]{ProviderManager.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        for (ClassLoader classLoader : classLoaders) {
            if (classLoader == null) continue;
            loaders.add(classLoader);
        }
        return loaders.toArray(new ClassLoader[loaders.size()]);
    }

    private ProviderManager() {
        this.initialize();
    }
}

