/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.catalog.impl;

import java.lang.reflect.Method;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;

public class OASISCatalogManager
extends CatalogManager
implements JAXWSCatalogManager {
    public static final String DEFAULT_CATALOG_WEB = "WEB-INF/jax-ws-catalog.xml";
    public static final String DEFAULT_CATALOG_EJB = "META-INF/jax-ws-catalog.xml";
    public static final String CATALOG_DEBUG_KEY = "OASISCatalogManager.catalog.debug.level";
    private ClassLoader classloader = null;
    private static final Logger LOG = Logger.getLogger(OASISCatalogManager.class.getName());
    private static String DEBUG_LEVEL = null;
    private Catalog staticCatalog = null;

    public OASISCatalogManager(ClassLoader classLoader) {
        this();
        this.classloader = classLoader;
    }

    public OASISCatalogManager(ClassLoader classLoader, String propertyFileName) {
        this(propertyFileName);
        this.classloader = classLoader;
    }

    public OASISCatalogManager() {
        String filepath;
        this.acceptDefaults();
        if (DEBUG_LEVEL != null) {
            this.debug.setDebug(Integer.parseInt(DEBUG_LEVEL));
        }
        if ((filepath = this.determineFileName()) != null) {
            this.setCatalogFiles(filepath);
        }
    }

    public OASISCatalogManager(String propertyFileName) {
        super(propertyFileName);
        if (DEBUG_LEVEL != null) {
            this.debug.setDebug(Integer.parseInt(DEBUG_LEVEL));
        }
    }

    private void acceptDefaults() {
        this.setUseStaticCatalog(true);
        this.setIgnoreMissingProperties(true);
    }

    public Catalog getCatalog() {
        Catalog catalog = this.staticCatalog;
        if (catalog == null || !super.getUseStaticCatalog()) {
            catalog = this.getPrivateCatalog();
        }
        return catalog;
    }

    private String determineFileName() {
        ClassLoader classLoader = this.classloader != null ? this.classloader : OASISCatalogManager.findClassLoader();
        URL url = classLoader.getResource(DEFAULT_CATALOG_WEB);
        if (url != null) {
            return url.toString();
        }
        url = classLoader.getResource(DEFAULT_CATALOG_EJB);
        return url == null ? null : url.toString();
    }

    public Catalog getPrivateCatalog() {
        try {
            Catalog catalog;
            final OASISCatalogManager cm = this;
            this.staticCatalog = catalog = (Catalog)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Catalog catalog = OASISCatalogManager.this.staticCatalog;
                    boolean useStatic = cm.getUseStaticCatalog();
                    if (catalog == null || !useStatic) {
                        String catalogClassName = OASISCatalogManager.this.getCatalogClassName();
                        if (catalogClassName == null) {
                            catalog = new Catalog();
                        } else {
                            try {
                                catalog = (Catalog)Class.forName(catalogClassName).newInstance();
                            }
                            catch (ClassNotFoundException cnfe) {
                                OASISCatalogManager.this.debug.message(1, "Catalog class named '" + catalogClassName + "' could not be found. Using default.");
                                catalog = new Catalog();
                            }
                            catch (ClassCastException cnfe) {
                                OASISCatalogManager.this.debug.message(1, "Class named '" + catalogClassName + "' is not a Catalog. Using default.");
                                catalog = new Catalog();
                            }
                        }
                        catalog.setCatalogManager(cm);
                        catalog.setupReaders();
                        catalog.loadSystemCatalogs();
                    }
                    return catalog;
                }
            });
            return catalog;
        }
        catch (PrivilegedActionException pae) {
            this.debug.message(1, "getPrivateCatatalog failed.  Processing continues " + pae.getException());
            return null;
        }
    }

    public void setCatalogFiles(String fileList) {
        this.staticCatalog = null;
        super.setCatalogFiles(fileList);
    }

    private static ClassLoader findClassLoader() {
        try {
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Method m = null;
                    try {
                        m = Thread.class.getMethod("getContextClassLoader", null);
                    }
                    catch (NoSuchMethodException e) {
                        return OASISCatalogManager.class.getClassLoader();
                    }
                    return (ClassLoader)m.invoke((Object)Thread.currentThread(), (Object[])null);
                }
            });
            return cl;
        }
        catch (PrivilegedActionException pae) {
            throw ExceptionFactory.makeWebServiceException(pae.getException());
        }
    }

    static {
        DEBUG_LEVEL = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(OASISCatalogManager.CATALOG_DEBUG_KEY);
                }
                catch (Throwable t) {
                    return null;
                }
            }
        });
    }
}

