/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.util.concurrent;

import de.hunsicker.util.concurrent.Callable;
import de.hunsicker.util.concurrent.TimeoutException;
import java.lang.reflect.InvocationTargetException;

public class FutureResult {
    protected InvocationTargetException exception_ = null;
    protected Object value_ = null;
    protected boolean ready_ = false;

    public synchronized void setException(Throwable ex) {
        this.exception_ = new InvocationTargetException(ex);
        this.ready_ = true;
        this.notifyAll();
    }

    public synchronized InvocationTargetException getException() {
        return this.exception_;
    }

    public synchronized boolean isReady() {
        return this.ready_;
    }

    public synchronized void clear() {
        this.value_ = null;
        this.exception_ = null;
        this.ready_ = false;
    }

    public synchronized Object get() throws InterruptedException, InvocationTargetException {
        while (!this.ready_) {
            this.wait();
        }
        return this.doGet();
    }

    public synchronized Object peek() {
        return this.value_;
    }

    public synchronized void set(Object newValue) {
        this.value_ = newValue;
        this.ready_ = true;
        this.notifyAll();
    }

    public Runnable setter(final Callable function) {
        return new Runnable(){

            public void run() {
                try {
                    FutureResult.this.set(function.call());
                }
                catch (Throwable ex) {
                    FutureResult.this.setException(ex);
                }
            }
        };
    }

    public synchronized Object timedGet(long msecs) throws TimeoutException, InterruptedException, InvocationTargetException {
        long startTime = msecs <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = msecs;
        if (this.ready_) {
            return this.doGet();
        }
        if (waitTime <= 0L) {
            throw new TimeoutException(msecs);
        }
        do {
            this.wait(waitTime);
            if (!this.ready_) continue;
            return this.doGet();
        } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
        throw new TimeoutException(msecs);
    }

    protected Object doGet() throws InvocationTargetException {
        if (this.exception_ != null) {
            throw this.exception_;
        }
        return this.value_;
    }
}

