/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context.effects;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

public class DragCache {
    private static Logger log = Logger.getLogger(DragCache.class.getName());
    private static final String CACHE_CLEARED = "ICESOFT_DRAG_CACHE_CLEARED_FLAG";
    private static final String CACHE_KEY = "ICESOFT_DRAG_CACHE_RGDM_FLAG";
    private static final String KEY_START = "ICEDRAGKEY[";
    private static final String KEY_END = "]ICEDRAGKEY";

    public static String put(Object value, FacesContext context) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        if (sessionMap.get(CACHE_KEY) == null) {
            sessionMap.put(CACHE_KEY, new HashMap());
        }
        Map cache = (Map)sessionMap.get(CACHE_KEY);
        String key = KEY_START + cache.size() + KEY_END;
        cache.put(key, value);
        return key;
    }

    public static Object get(String key, FacesContext context) {
        if (key == null) {
            throw new NullPointerException("Key can't be null");
        }
        key = key.trim();
        Map sessionMap = context.getExternalContext().getSessionMap();
        Map cache = (Map)sessionMap.get(CACHE_KEY);
        if (cache == null) {
            throw new IllegalStateException("No Drag component placed a value in the cache.");
        }
        Object o = cache.get(key);
        if (o == null) {
            log.log(Level.SEVERE, "DragCache: No value found for key [" + key + "]");
        }
        return cache.get(key);
    }
}

