/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.concurrent;

import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.concurrent.ConcurrentLoginException;
import org.acegisecurity.concurrent.ConcurrentSessionController;
import org.acegisecurity.concurrent.SessionInformation;
import org.acegisecurity.concurrent.SessionRegistry;
import org.acegisecurity.concurrent.SessionRegistryImpl;
import org.acegisecurity.concurrent.SessionRegistryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.Assert;

public class ConcurrentSessionControllerImpl
implements ConcurrentSessionController,
InitializingBean,
MessageSourceAware {
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();
    private SessionRegistry sessionRegistry = new SessionRegistryImpl();
    private boolean exceptionIfMaximumExceeded = false;
    private int maximumSessions = 1;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sessionRegistry, (String)"SessionRegistry required");
        Assert.isTrue((this.maximumSessions != 0 ? 1 : 0) != 0, (String)"MaximumLogins must be either -1 to allow unlimited logins, or a positive integer to specify a maximum");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
    }

    protected void allowableSessionsExceeded(String sessionId, SessionInformation[] sessions, int allowableSessions, SessionRegistry registry) {
        if (this.exceptionIfMaximumExceeded || sessions == null) {
            throw new ConcurrentLoginException(this.messages.getMessage("ConcurrentSessionControllerImpl.exceededAllowed", new Object[]{new Integer(allowableSessions)}, "Maximum sessions of {0} for this principal exceeded"));
        }
        SessionInformation leastRecentlyUsed = null;
        for (int i = 0; i < sessions.length; ++i) {
            if (leastRecentlyUsed != null && !sessions[i].getLastRequest().before(leastRecentlyUsed.getLastRequest())) continue;
            leastRecentlyUsed = sessions[i];
        }
        leastRecentlyUsed.expireNow();
    }

    public void checkAuthenticationAllowed(Authentication request) throws AuthenticationException {
        int allowableSessions;
        Assert.notNull((Object)request, (String)"Authentication request cannot be null (violation of interface contract)");
        Object principal = SessionRegistryUtils.obtainPrincipalFromAuthentication(request);
        String sessionId = SessionRegistryUtils.obtainSessionIdFromAuthentication(request);
        SessionInformation[] sessions = this.sessionRegistry.getAllSessions(principal, false);
        int sessionCount = 0;
        if (sessions != null) {
            sessionCount = sessions.length;
        }
        Assert.isTrue(((allowableSessions = this.getMaximumSessionsForThisUser(request)) != 0 ? 1 : 0) != 0, (String)"getMaximumSessionsForThisUser() must return either -1 to allow unlimited logins, or a positive integer to specify a maximum");
        if (sessionCount < allowableSessions) {
            return;
        }
        if (allowableSessions == -1) {
            return;
        }
        if (sessionCount == allowableSessions) {
            for (int i = 0; i < sessionCount; ++i) {
                if (!sessions[i].getSessionId().equals(sessionId)) continue;
                return;
            }
        }
        this.allowableSessionsExceeded(sessionId, sessions, allowableSessions, this.sessionRegistry);
    }

    protected int getMaximumSessionsForThisUser(Authentication authentication) {
        return this.maximumSessions;
    }

    public void registerSuccessfulAuthentication(Authentication authentication) {
        Assert.notNull((Object)authentication, (String)"Authentication cannot be null (violation of interface contract)");
        Object principal = SessionRegistryUtils.obtainPrincipalFromAuthentication(authentication);
        String sessionId = SessionRegistryUtils.obtainSessionIdFromAuthentication(authentication);
        this.sessionRegistry.removeSessionInformation(sessionId);
        this.sessionRegistry.registerNewSession(sessionId, principal);
    }

    public void setExceptionIfMaximumExceeded(boolean exceptionIfMaximumExceeded) {
        this.exceptionIfMaximumExceeded = exceptionIfMaximumExceeded;
    }

    public void setMaximumSessions(int maximumSessions) {
        this.maximumSessions = maximumSessions;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }
}

