/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.swing.PreviewFrame;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.jalopy.swing.ValidationException;
import de.hunsicker.util.ResourceBundleFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.Timer;

public abstract class AbstractSettingsPage
extends JPanel {
    protected static final String DELIMETER = "|";
    protected final ResourceBundle bundle;
    protected Convention settings;
    final ActionListener trigger = new UpdateTrigger();
    SettingsContainer _container;
    private String _category;
    private String _title;

    public AbstractSettingsPage() {
        this.settings = Convention.getInstance();
        this.bundle = ResourceBundleFactory.getBundle("de.hunsicker.jalopy.swing.Bundle");
    }

    AbstractSettingsPage(SettingsContainer container) {
        this();
        this._container = container;
    }

    public void setCategory(String category) {
        this._category = category;
    }

    public String getCategory() {
        return this._category;
    }

    public void setConvention(Convention convention) {
        this.settings = convention;
    }

    public Convention getConvention() {
        return this.settings;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public abstract void updateSettings();

    public void validateSettings() throws ValidationException {
    }

    protected String[] createItemList(int[] values) {
        String[] items = new String[values.length];
        int i = 0;
        while (i < values.length) {
            items[i] = String.valueOf(values[i]).intern();
            ++i;
        }
        return items;
    }

    SettingsContainer getContainer() {
        return this._container;
    }

    protected String getPreviewFileName() {
        return this._category;
    }

    private final class UpdateTrigger
    implements ActionListener {
        Timer timer;

        private UpdateTrigger() {
        }

        public synchronized void actionPerformed(ActionEvent ev) {
            if (AbstractSettingsPage.this._container != null) {
                if (this.timer == null) {
                    this.timer = new Timer(20, new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            timer.stop();
                            PreviewFrame preview = ((UpdateTrigger)this).AbstractSettingsPage.this._container.getPreview();
                            String filename = AbstractSettingsPage.this.getPreviewFileName();
                            String text = ((UpdateTrigger)this).AbstractSettingsPage.this._container.loadPreview(filename);
                            try {
                                preview.getCurrentPage().validateSettings();
                                if (preview.customFile) {
                                    preview.update();
                                } else {
                                    preview.setText(text);
                                }
                            }
                            catch (ValidationException ex) {
                                return;
                            }
                            catch (Throwable ex) {
                                ex.printStackTrace();
                            }
                        }
                    });
                    this.timer.start();
                } else {
                    this.timer.restart();
                }
            }
        }
    }
}

